/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logout.config;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.ServiceFactoryConfigurer;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.DefaultLogoutExecutionPlan;
import org.apereo.cas.logout.DefaultLogoutManager;
import org.apereo.cas.logout.DefaultLogoutRedirectionStrategy;
import org.apereo.cas.logout.DefaultSingleLogoutMessageCreator;
import org.apereo.cas.logout.LogoutExecutionPlan;
import org.apereo.cas.logout.LogoutExecutionPlanConfigurer;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.logout.LogoutRedirectionStrategy;
import org.apereo.cas.logout.LogoutWebApplicationServiceFactory;
import org.apereo.cas.logout.slo.ChainingSingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.slo.DefaultSingleLogoutRequestExecutor;
import org.apereo.cas.logout.slo.DefaultSingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.slo.DefaultSingleLogoutServiceMessageHandler;
import org.apereo.cas.logout.slo.SingleLogoutMessageCreator;
import org.apereo.cas.logout.slo.SingleLogoutRequestExecutor;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilderConfigurer;
import org.apereo.cas.logout.slo.SingleLogoutServiceMessageHandler;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.web.UrlValidator;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@Configuration(value="CasCoreLogoutConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCoreLogoutConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreLogoutConfiguration.class);

    @Configuration(value="CasCoreLogoutExecutorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreLogoutExecutorConfiguration {
        @ConditionalOnMissingBean(name={"defaultSingleLogoutRequestExecutor"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public SingleLogoutRequestExecutor defaultSingleLogoutRequestExecutor(@Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="logoutManager") LogoutManager logoutManager, ConfigurableApplicationContext applicationContext) {
            return new DefaultSingleLogoutRequestExecutor(centralAuthenticationService, logoutManager, (ApplicationContext)applicationContext);
        }
    }

    @Configuration(value="CasCoreLogoutServiceConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @AutoConfigureOrder(value=-2147483648)
    public static class CasCoreLogoutServiceConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"logoutWebApplicationServiceFactory"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceFactory<WebApplicationService> logoutWebApplicationServiceFactory(CasConfigurationProperties casProperties) {
            return new LogoutWebApplicationServiceFactory(casProperties.getLogout());
        }

        @Bean
        @ConditionalOnMissingBean(name={"logoutWebApplicationServiceFactoryConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceFactoryConfigurer logoutWebApplicationServiceFactoryConfigurer(@Qualifier(value="logoutWebApplicationServiceFactory") ServiceFactory<WebApplicationService> logoutWebApplicationServiceFactory) {
            return () -> CollectionUtils.wrap((Object)logoutWebApplicationServiceFactory);
        }
    }

    @Configuration(value="CasCoreLogoutExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreLogoutExecutionPlanConfiguration {
        @ConditionalOnMissingBean(name={"logoutExecutionPlan"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public LogoutExecutionPlan logoutExecutionPlan(List<LogoutExecutionPlanConfigurer> configurers) {
            DefaultLogoutExecutionPlan plan = new DefaultLogoutExecutionPlan();
            configurers.forEach(c -> {
                LOGGER.trace("Configuring logout execution plan [{}]", (Object)c.getName());
                c.configureLogoutExecutionPlan((LogoutExecutionPlan)plan);
            });
            return plan;
        }
    }

    @Configuration(value="CasCoreLogoutExecutionPlanBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreLogoutExecutionPlanBaseConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"casCoreLogoutExecutionPlanConfigurer"})
        public LogoutExecutionPlanConfigurer casCoreLogoutExecutionPlanConfigurer(CasConfigurationProperties casProperties, @Qualifier(value="defaultSingleLogoutServiceMessageHandler") SingleLogoutServiceMessageHandler defaultSingleLogoutServiceMessageHandler, @Qualifier(value="defaultLogoutRedirectionStrategy") LogoutRedirectionStrategy defaultLogoutRedirectionStrategy, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry) {
            return plan -> {
                plan.registerSingleLogoutServiceMessageHandler(defaultSingleLogoutServiceMessageHandler);
                plan.registerLogoutRedirectionStrategy(defaultLogoutRedirectionStrategy);
                if (casProperties.getLogout().isRemoveDescendantTickets()) {
                    LOGGER.debug("CAS is configured to remove descendant tickets of the ticket-granting tickets");
                    plan.registerLogoutPostProcessor(tgt -> tgt.getDescendantTickets().forEach(Unchecked.consumer(t -> {
                        LOGGER.debug("Deleting ticket [{}] from the registry as a descendant of [{}]", t, (Object)tgt.getId());
                        ticketRegistry.deleteTicket(t);
                    })));
                }
            };
        }
    }

    @Configuration(value="CasCoreLogoutManagementConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreLogoutManagementConfiguration {
        @ConditionalOnMissingBean(name={"logoutManager"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public LogoutManager logoutManager(@Qualifier(value="logoutExecutionPlan") LogoutExecutionPlan logoutExecutionPlan, CasConfigurationProperties casProperties) {
            return new DefaultLogoutManager(casProperties.getSlo().isDisabled(), logoutExecutionPlan);
        }
    }

    @Configuration(value="CasCoreLogoutMessagesConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreLogoutMessagesConfiguration {
        @ConditionalOnMissingBean(name={"defaultSingleLogoutServiceMessageHandler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleLogoutServiceMessageHandler defaultSingleLogoutServiceMessageHandler(@Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, @Qualifier(value="defaultSingleLogoutMessageCreator") SingleLogoutMessageCreator defaultSingleLogoutMessageCreator, @Qualifier(value="noRedirectHttpClient") HttpClient noRedirectHttpClient, @Qualifier(value="singleLogoutServiceLogoutUrlBuilder") SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder) {
            return new DefaultSingleLogoutServiceMessageHandler(noRedirectHttpClient, defaultSingleLogoutMessageCreator, servicesManager, singleLogoutServiceLogoutUrlBuilder, casProperties.getSlo().isAsynchronous(), authenticationServiceSelectionPlan);
        }

        @ConditionalOnMissingBean(name={"defaultSingleLogoutMessageCreator"})
        @Bean
        public SingleLogoutMessageCreator defaultSingleLogoutMessageCreator() {
            return new DefaultSingleLogoutMessageCreator();
        }
    }

    @Configuration(value="CasCoreLogoutRedirectConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreLogoutRedirectConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"defaultLogoutRedirectionStrategy"})
        public LogoutRedirectionStrategy defaultLogoutRedirectionStrategy(CasConfigurationProperties casProperties, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="singleLogoutServiceLogoutUrlBuilder") SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder) {
            return new DefaultLogoutRedirectionStrategy(argumentExtractor, casProperties, singleLogoutServiceLogoutUrlBuilder, webApplicationServiceFactory);
        }
    }

    @Configuration(value="CasCoreLogoutUrlBuilderConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreLogoutUrlBuilderConfiguration {
        @ConditionalOnMissingBean(name={"singleLogoutServiceLogoutUrlBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder(List<SingleLogoutServiceLogoutUrlBuilderConfigurer> configurers) {
            List results = configurers.stream().sorted(Comparator.comparing(SingleLogoutServiceLogoutUrlBuilderConfigurer::getOrder)).map(cfg -> {
                SingleLogoutServiceLogoutUrlBuilder builder = cfg.configureBuilder();
                LOGGER.trace("Configuring single logout url builder [{}]", (Object)builder.getName());
                return builder;
            }).map(SingleLogoutServiceLogoutUrlBuilder.class::cast).sorted(Comparator.comparing(SingleLogoutServiceLogoutUrlBuilder::getOrder)).collect(Collectors.toList());
            return new ChainingSingleLogoutServiceLogoutUrlBuilder(results);
        }

        @ConditionalOnMissingBean(name={"defaultSingleLogoutServiceLogoutUrlBuilderConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleLogoutServiceLogoutUrlBuilderConfigurer defaultSingleLogoutServiceLogoutUrlBuilderConfigurer(@Qualifier(value="urlValidator") UrlValidator urlValidator, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return () -> new DefaultSingleLogoutServiceLogoutUrlBuilder(servicesManager, urlValidator);
        }
    }
}

