/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.services.ServiceRegistryProperties;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.configuration.model.support.sms.SmsProperties;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.notifications.mail.EmailMessageBodyBuilder;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServicesEventListener;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.events.service.CasRegisteredServiceExpiredEvent;
import org.apereo.cas.support.events.service.CasRegisteredServicesRefreshEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;

public class DefaultRegisteredServicesEventListener
implements RegisteredServicesEventListener {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRegisteredServicesEventListener.class);
    private final ServicesManager servicesManager;
    private final CasConfigurationProperties casProperties;
    private final CommunicationsManager communicationsManager;

    @Override
    public void handleRefreshEvent(CasRegisteredServicesRefreshEvent event) {
        this.servicesManager.load();
    }

    @Override
    public void handleEnvironmentChangeEvent(EnvironmentChangeEvent event) {
        this.servicesManager.load();
    }

    @Override
    public void handleRegisteredServiceExpiredEvent(CasRegisteredServiceExpiredEvent event) {
        RegisteredService registeredService = event.getRegisteredService();
        List contacts = registeredService.getContacts();
        ServiceRegistryProperties serviceRegistry = this.casProperties.getServiceRegistry();
        String serviceName = (String)StringUtils.defaultIfBlank((CharSequence)registeredService.getName(), (CharSequence)registeredService.getServiceId());
        if (contacts == null || contacts.isEmpty()) {
            LOGGER.debug("No contacts are defined to be notified for policy changes to service [{}]", (Object)serviceName);
            return;
        }
        String logMessage = String.format("Sending notification to [{}] as service [{}] is %s from registry", event.isDeleted() ? "deleted" : "expired");
        LOGGER.info(logMessage, (Object)contacts, (Object)serviceName);
        this.communicationsManager.validate();
        if (this.communicationsManager.isMailSenderDefined()) {
            EmailProperties mail = serviceRegistry.getMail();
            String body = EmailMessageBodyBuilder.builder().properties(mail).parameters(Map.of("service", serviceName)).build().produce();
            contacts.stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getEmail())).forEach(c -> this.communicationsManager.email(mail, c.getEmail(), body));
        }
        if (this.communicationsManager.isSmsSenderDefined()) {
            SmsProperties sms = serviceRegistry.getSms();
            String message = sms.getFormattedText(new Object[]{serviceName});
            contacts.stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getPhone())).forEach(c -> this.communicationsManager.sms(sms.getFrom(), c.getPhone(), message));
        }
    }

    @Generated
    public DefaultRegisteredServicesEventListener(ServicesManager servicesManager, CasConfigurationProperties casProperties, CommunicationsManager communicationsManager) {
        this.servicesManager = servicesManager;
        this.casProperties = casProperties;
        this.communicationsManager = communicationsManager;
    }
}

