/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.AbstractRegisteredService;
import org.apereo.cas.services.FullRegexRegisteredServiceMatchingStrategy;
import org.apereo.cas.services.RegisteredService;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class RegexRegisteredService
extends AbstractRegisteredService {
    public static final String FRIENDLY_NAME = "CAS Client";
    private static final long serialVersionUID = -8258660210826975771L;

    @Override
    public void setServiceId(String id) {
        this.serviceId = id;
    }

    public boolean matches(Service service) {
        return service != null && this.matches(service.getId());
    }

    public boolean matches(String serviceId) {
        this.configureMatchingStrategy();
        return !StringUtils.isBlank((CharSequence)serviceId) && this.getMatchingStrategy().matches((RegisteredService)this, serviceId);
    }

    @JsonIgnore
    public String getFriendlyName() {
        return FRIENDLY_NAME;
    }

    protected void configureMatchingStrategy() {
        if (this.getMatchingStrategy() == null) {
            this.setMatchingStrategy(new FullRegexRegisteredServiceMatchingStrategy());
        }
    }

    @Override
    protected AbstractRegisteredService newInstance() {
        return new RegexRegisteredService();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegexRegisteredService)) {
            return false;
        }
        RegexRegisteredService other = (RegexRegisteredService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RegexRegisteredService;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

