/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceSingleSignOnParticipationPolicy;
import org.apereo.cas.ticket.AuthenticationAwareTicket;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy
implements RegisteredServiceSingleSignOnParticipationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy.class);
    private static final long serialVersionUID = -1223946898337761319L;
    private Map<String, List<String>> attributes = new HashMap<String, List<String>>();
    private boolean requireAllAttributes;

    public boolean shouldParticipateInSso(RegisteredService registeredService, AuthenticationAwareTicket ticketState) {
        boolean participation;
        Authentication authentication = ticketState.getAuthentication();
        boolean bl = participation = this.doPrincipalAttributesAllowParticipationInSso(authentication.getPrincipal().getAttributes()) || this.doPrincipalAttributesAllowParticipationInSso(authentication.getAttributes());
        if (!participation) {
            LOGGER.debug("No SSO participation is allowed since none of the defined attributes [{}] match authentication/principal attributes\n".stripIndent(), this.attributes);
            return false;
        }
        return true;
    }

    protected boolean doPrincipalAttributesAllowParticipationInSso(Map<String, List<Object>> givenAttributes) {
        LOGGER.debug("Attributes examined for SSO participation are [{}]", givenAttributes);
        if (this.requireAllAttributes) {
            return this.attributes.entrySet().stream().allMatch(entry -> AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy.examineAttributeValues(givenAttributes, entry));
        }
        return this.attributes.entrySet().stream().anyMatch(entry -> AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy.examineAttributeValues(givenAttributes, entry));
    }

    private static boolean examineAttributeValues(Map<String, List<Object>> givenAttributes, Map.Entry<String, List<String>> entry) {
        String key = SpringExpressionLanguageValueResolver.getInstance().resolve(entry.getKey());
        List attributeValues = givenAttributes.getOrDefault(key, List.of());
        return entry.getValue().stream().anyMatch(pattern -> attributeValues.stream().anyMatch(attrValue -> {
            String attributeValue = attrValue.toString();
            String resolvedPattern = SpringExpressionLanguageValueResolver.getInstance().resolve(pattern);
            LOGGER.trace("Comparing [{}] against pattern [{}]", (Object)attributeValue, (Object)resolvedPattern);
            return RegexUtils.find((String)resolvedPattern, (String)attributeValue);
        }));
    }

    @Generated
    public String toString() {
        return "AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy(super=" + super.toString() + ", attributes=" + String.valueOf(this.attributes) + ", requireAllAttributes=" + this.requireAllAttributes + ")";
    }

    @Generated
    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    @Generated
    public boolean isRequireAllAttributes() {
        return this.requireAllAttributes;
    }

    @Generated
    public AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy setAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
        return this;
    }

    @Generated
    public AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy setRequireAllAttributes(boolean requireAllAttributes) {
        this.requireAllAttributes = requireAllAttributes;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy)) {
            return false;
        }
        AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy other = (AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.requireAllAttributes != other.requireAllAttributes) {
            return false;
        }
        Map<String, List<String>> this$attributes = this.attributes;
        Map<String, List<String>> other$attributes = other.attributes;
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.requireAllAttributes ? 79 : 97);
        Map<String, List<String>> $attributes = this.attributes;
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    @Generated
    public AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy() {
    }
}

