/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceMatchingStrategy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceMatchingStrategy
implements ServiceMatchingStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServiceMatchingStrategy.class);
    private final ServicesManager servicesManager;

    public boolean matches(Service service, Service serviceToMatch) {
        try {
            String thisUrl = URLDecoder.decode(service.getId(), StandardCharsets.UTF_8.name());
            String serviceUrl = URLDecoder.decode(serviceToMatch.getId(), StandardCharsets.UTF_8.name());
            LOGGER.trace("Decoded urls and comparing [{}] with [{}]", (Object)thisUrl, (Object)serviceUrl);
            return thisUrl.equalsIgnoreCase(serviceUrl);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return false;
        }
    }

    @Generated
    public DefaultServiceMatchingStrategy(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }
}

