/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.googlecode.cqengine.attribute.Attribute;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.RegexRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.query.BasicRegisteredServiceQueryIndex;
import org.apereo.cas.services.query.RegisteredServiceQueryAttribute;
import org.apereo.cas.services.query.RegisteredServiceQueryIndex;
import org.apereo.cas.util.CollectionUtils;

public class DefaultServicesManagerRegisteredServiceLocator
implements ServicesManagerRegisteredServiceLocator {
    private int order = -1000;
    private BiPredicate<RegisteredService, Service> registeredServiceFilter = (registeredService, service) -> {
        boolean supportedType = this.supports((RegisteredService)registeredService, (Service)service);
        return supportedType && registeredService.matches(service.getId());
    };

    public RegisteredService locate(Collection<? extends RegisteredService> candidates, Service service) {
        return candidates.stream().filter(registeredService -> this.supports((RegisteredService)registeredService, service)).filter(registeredService -> this.registeredServiceFilter.test((RegisteredService)registeredService, service)).findFirst().orElse(null);
    }

    public boolean supports(RegisteredService registeredService, Service service) {
        return this.getRegisteredServiceIndexedType().isAssignableFrom(registeredService.getClass()) && registeredService.getFriendlyName().equalsIgnoreCase("CAS Client") || RegexRegisteredService.class.isAssignableFrom(registeredService.getClass()) && registeredService.getFriendlyName().equalsIgnoreCase("CAS Client");
    }

    public List<RegisteredServiceQueryIndex> getRegisteredServiceIndexes() {
        Class<? extends RegisteredService> registeredServiceIndexedType = this.getRegisteredServiceIndexedType();
        return CollectionUtils.wrapArrayList((Object[])new RegisteredServiceQueryIndex[]{BasicRegisteredServiceQueryIndex.hashIndex((Attribute)new RegisteredServiceQueryAttribute(registeredServiceIndexedType, Long.TYPE, "id")), BasicRegisteredServiceQueryIndex.hashIndex((Attribute)new RegisteredServiceQueryAttribute(registeredServiceIndexedType, String.class, "name")), BasicRegisteredServiceQueryIndex.hashIndex((Attribute)new RegisteredServiceQueryAttribute(registeredServiceIndexedType, String.class, "serviceId")), BasicRegisteredServiceQueryIndex.hashIndex((Attribute)new RegisteredServiceQueryAttribute(registeredServiceIndexedType, String.class, "friendlyName")), BasicRegisteredServiceQueryIndex.hashIndex((Attribute)new RegisteredServiceQueryAttribute(registeredServiceIndexedType, String.class, "@class"))});
    }

    protected Class<? extends RegisteredService> getRegisteredServiceIndexedType() {
        return CasRegisteredService.class;
    }

    @Generated
    public DefaultServicesManagerRegisteredServiceLocator(int order, BiPredicate<RegisteredService, Service> registeredServiceFilter) {
        this.order = order;
        this.registeredServiceFilter = registeredServiceFilter;
    }

    @Generated
    public DefaultServicesManagerRegisteredServiceLocator() {
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public void setRegisteredServiceFilter(BiPredicate<RegisteredService, Service> registeredServiceFilter) {
        this.registeredServiceFilter = registeredServiceFilter;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public BiPredicate<RegisteredService, Service> getRegisteredServiceFilter() {
        return this.registeredServiceFilter;
    }
}

