/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.services.AbstractServiceRegistry;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceDefinition;
import org.apereo.cas.services.ServiceRegistryListener;
import org.apereo.cas.support.events.service.CasRegisteredServiceLoadedEvent;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;

public class InMemoryServiceRegistry
extends AbstractServiceRegistry {
    private final List<RegisteredService> registeredServices;

    public InMemoryServiceRegistry(ConfigurableApplicationContext applicationContext) {
        this(applicationContext, new ArrayList<RegisteredService>(0), new ArrayList<ServiceRegistryListener>(0));
    }

    public InMemoryServiceRegistry(ConfigurableApplicationContext applicationContext, List<RegisteredService> registeredServices, Collection<ServiceRegistryListener> serviceRegistryListeners) {
        super(applicationContext, serviceRegistryListeners);
        this.registeredServices = registeredServices;
    }

    public RegisteredService save(RegisteredService registeredService) {
        if (registeredService.getId() == -1L) {
            registeredService.setId(this.findHighestId() + 1L);
        }
        this.invokeServiceRegistryListenerPreSave(registeredService);
        RegisteredService svc = this.findServiceById(registeredService.getId());
        if (svc != null) {
            this.registeredServices.remove(svc);
        }
        this.registeredServices.add(registeredService);
        return registeredService;
    }

    public boolean delete(RegisteredService registeredService) {
        return !this.registeredServices.contains(registeredService) || this.registeredServices.remove(registeredService);
    }

    public void deleteAll() {
        this.registeredServices.clear();
    }

    public Collection<RegisteredService> load() {
        ArrayList<RegisteredService> services = new ArrayList<RegisteredService>(this.registeredServices.size());
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        this.registeredServices.stream().map(this::invokeServiceRegistryListenerPostLoad).filter(Objects::nonNull).forEach(s -> {
            this.publishEvent((ApplicationEvent)new CasRegisteredServiceLoadedEvent((Object)this, s, clientInfo));
            services.add((RegisteredService)s);
        });
        return services;
    }

    public Stream<? extends RegisteredService> getServicesStream() {
        return this.registeredServices.stream();
    }

    public RegisteredService findServiceById(long id) {
        return this.registeredServices.stream().filter(r -> r.getId() == id).findFirst().orElse(null);
    }

    public long size() {
        return this.registeredServices.size();
    }

    private long findHighestId() {
        return this.registeredServices.stream().map(RegisteredServiceDefinition::getId).max(Comparator.naturalOrder()).orElse(0L);
    }

    @Generated
    public String toString() {
        return "InMemoryServiceRegistry(registeredServices=" + String.valueOf(this.registeredServices) + ")";
    }
}

