/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.monitor.ExecutableObserver;
import org.apereo.cas.monitor.MonitorableTask;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.tracing.ConditionalOnEnabledTracing;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Monitoring, CasFeatureModule.FeatureCatalog.TicketRegistry})
@ConditionalOnBean(name={"defaultExecutableObserver"})
@AutoConfiguration
@AutoConfigureOrder(value=0x7FFFFFFF)
@Lazy(value=false)
@ConditionalOnEnabledTracing
public class CasCoreTicketsMonitoringConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"ticketRegistryMonitoringAspect"})
    public TicketRegistryMonitoringAspect ticketRegistryMonitoringAspect(ObjectProvider<ExecutableObserver> observer) {
        return new TicketRegistryMonitoringAspect(observer);
    }

    @Aspect
    record TicketRegistryMonitoringAspect(ObjectProvider<ExecutableObserver> observerProvider) {
        @Generated
        private static final Logger LOGGER = LoggerFactory.getLogger(TicketRegistryMonitoringAspect.class);

        @Around(value="allComponentsInTicketRegistryNamespace()")
        public Object aroundTicketRegistryOperations(ProceedingJoinPoint joinPoint) throws Throwable {
            ExecutableObserver observer = (ExecutableObserver)this.observerProvider.getObject();
            String taskName = joinPoint.getSignature().getDeclaringTypeName() + "." + joinPoint.getSignature().getName();
            MonitorableTask task = new MonitorableTask(taskName);
            return observer.supply(task, () -> TicketRegistryMonitoringAspect.executeJoinpoint(joinPoint));
        }

        private static Object executeJoinpoint(ProceedingJoinPoint joinPoint) {
            return FunctionUtils.doUnchecked(() -> {
                Object[] args = joinPoint.getArgs();
                LOGGER.trace("Executing [{}]", (Object)joinPoint.getStaticPart().toLongString());
                return joinPoint.proceed(args);
            });
        }

        @Pointcut(value="within(org.apereo.cas.ticket.registry.*)")
        private void allComponentsInTicketRegistryNamespace() {
        }
    }
}

