/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.jooq.lambda.Unchecked;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpResponse;

public final class JsonUtils {
    public static void render(Object model, HttpServletResponse response) {
        Unchecked.consumer(o -> {
            MappingJackson2HttpMessageConverter jsonConverter = new MappingJackson2HttpMessageConverter();
            jsonConverter.setPrettyPrint(true);
            MediaType jsonMimeType = MediaType.APPLICATION_JSON;
            jsonConverter.write(model, jsonMimeType, (HttpOutputMessage)new ServletServerHttpResponse(response));
        }).accept(model);
    }

    public static void render(HttpServletResponse response) {
        HashMap map = new HashMap();
        response.setStatus(200);
        JsonUtils.render(map, response);
    }

    public static void renderException(Exception ex, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("error", ex.getMessage());
        map.put("stacktrace", Arrays.deepToString(ex.getStackTrace()));
        JsonUtils.renderException(map, response);
    }

    private static void renderException(Map<String, Object> model, HttpServletResponse response) {
        response.setStatus(400);
        model.put("status", 400);
        JsonUtils.render(model, response);
    }

    @Generated
    private JsonUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

