/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;

public final class LoggingUtils {
    public static void error(Logger logger, String msg) {
        logger.error(msg);
    }

    public static void error(Logger logger, String msg, Throwable throwable) {
        logger.error(msg, throwable);
    }

    public static void error(Logger logger, Throwable throwable) {
        LoggingUtils.error(logger, LoggingUtils.getMessage(throwable), throwable);
    }

    public static void warn(Logger logger, Throwable throwable) {
        LoggingUtils.warn(logger, LoggingUtils.getMessage(throwable), throwable);
    }

    public static void warn(Logger logger, String message, Throwable throwable) {
        logger.warn(message, throwable);
    }

    static String getMessage(Throwable throwable) {
        Optional<String> message;
        if (StringUtils.isEmpty((CharSequence)throwable.getMessage()) && (message = ExceptionUtils.getThrowableList((Throwable)throwable).stream().map(Throwable::getMessage).filter(Objects::nonNull).findFirst()).isPresent()) {
            return message.get();
        }
        return (String)StringUtils.defaultIfEmpty((CharSequence)throwable.getMessage(), (CharSequence)throwable.getClass().getSimpleName());
    }

    @Generated
    private LoggingUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

