/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.serialization.StringSerializer;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.hjson.JsonValue;
import org.hjson.Stringify;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJacksonBackedStringSerializer<T>
implements StringSerializer<T> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJacksonBackedStringSerializer.class);
    protected static final PrettyPrinter MINIMAL_PRETTY_PRINTER = new MinimalPrettyPrinter();
    private static final long serialVersionUID = -8415599777321259365L;
    private final ObjectMapper objectMapper;
    private final transient PrettyPrinter prettyPrinter;

    protected AbstractJacksonBackedStringSerializer() {
        this((PrettyPrinter)new DefaultPrettyPrinter());
    }

    protected AbstractJacksonBackedStringSerializer(PrettyPrinter prettyPrinter) {
        this.objectMapper = this.initializeObjectMapper();
        this.prettyPrinter = prettyPrinter;
    }

    private boolean isJsonFormat() {
        return !(this.objectMapper.getFactory() instanceof YAMLFactory);
    }

    public T from(String json) {
        String jsonString = this.isJsonFormat() ? JsonValue.readHjson((String)json).toString() : json;
        return this.readObjectFromString(jsonString);
    }

    public T from(File json) {
        String string = this.isJsonFormat() ? JsonValue.readHjson((String)FileUtils.readFileToString((File)json, (Charset)StandardCharsets.UTF_8)).toString() : FileUtils.readFileToString((File)json, (Charset)StandardCharsets.UTF_8);
        return this.readObjectFromString(string);
    }

    public T from(Reader json) {
        String string = this.isJsonFormat() ? JsonValue.readHjson((Reader)json).toString() : String.join((CharSequence)"\n", IOUtils.readLines((Reader)json));
        return this.readObjectFromString(string);
    }

    public T from(Writer writer) {
        return this.from(writer.toString());
    }

    public T from(InputStream json) {
        String jsonString = this.readJsonFrom(json);
        return this.readObjectFromString(jsonString);
    }

    protected String readJsonFrom(InputStream json) throws IOException {
        return this.isJsonFormat() ? JsonValue.readHjson((String)IOUtils.toString((InputStream)json, (Charset)StandardCharsets.UTF_8)).toString() : String.join((CharSequence)"\n", IOUtils.readLines((InputStream)json, (Charset)StandardCharsets.UTF_8));
    }

    public void to(OutputStream out, T object) {
        try (StringWriter writer = new StringWriter();){
            this.objectMapper.writer(this.prettyPrinter).writeValue((Writer)writer, object);
            String hjsonString = this.isJsonFormat() ? JsonValue.readHjson((String)writer.toString()).toString(Stringify.HJSON) : writer.toString();
            IOUtils.write((String)hjsonString, (OutputStream)out, (Charset)StandardCharsets.UTF_8);
        }
    }

    public void to(Writer out, T object) {
        try (StringWriter writer = new StringWriter();){
            this.objectMapper.writer(this.prettyPrinter).writeValue((Writer)writer, object);
            if (this.isJsonFormat()) {
                Stringify opt = this.prettyPrinter instanceof MinimalPrettyPrinter ? Stringify.PLAIN : Stringify.FORMATTED;
                JsonValue.readHjson((String)writer.toString()).writeTo(out, opt);
            } else {
                IOUtils.write((String)writer.toString(), (Writer)out);
            }
        }
    }

    public void to(File out, T object) {
        block14: {
            try (StringWriter writer = new StringWriter();){
                this.objectMapper.writer(this.prettyPrinter).writeValue((Writer)writer, object);
                if (this.isJsonFormat()) {
                    try (BufferedWriter fileWriter = Files.newBufferedWriter(out.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                        Stringify opt = this.prettyPrinter instanceof MinimalPrettyPrinter ? Stringify.PLAIN : Stringify.FORMATTED;
                        JsonValue.readHjson((String)writer.toString()).writeTo((Writer)fileWriter, opt);
                        fileWriter.flush();
                        break block14;
                    }
                }
                FileUtils.write((File)out, (CharSequence)writer.toString(), (Charset)StandardCharsets.UTF_8);
            }
        }
    }

    public String toString(T object) {
        String string;
        try (StringWriter writer = new StringWriter();){
            this.to(writer, object);
            string = writer.toString();
        }
        return string;
    }

    protected ObjectMapper initializeObjectMapper() {
        ObjectMapper mapper = ((JacksonObjectMapperFactory)((JacksonObjectMapperFactory.JacksonObjectMapperFactoryBuilder)((JacksonObjectMapperFactory.JacksonObjectMapperFactoryBuilder)JacksonObjectMapperFactory.builder().defaultTypingEnabled(this.isDefaultTypingEnabled())).jsonFactory(this.getJsonFactory())).build()).toObjectMapper();
        this.configureObjectMapper(mapper);
        return mapper;
    }

    protected void configureObjectMapper(ObjectMapper mapper) {
    }

    protected boolean isDefaultTypingEnabled() {
        return true;
    }

    protected JsonFactory getJsonFactory() {
        return null;
    }

    protected T readObjectFromString(String jsonString) {
        try {
            LOGGER.trace("Attempting to consume [{}]", (Object)jsonString);
            ApplicationContextProvider.getCasConfigurationProperties().ifPresent(casProperties -> {
                LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>(casProperties.getAuthn().getSamlIdp().getServices().getDefaults());
                JacksonObjectMapperFactory.RelaxedInjectableValueProvider injectables = new JacksonObjectMapperFactory.RelaxedInjectableValueProvider(values);
                this.objectMapper.setInjectableValues((InjectableValues)injectables);
            });
            return (T)this.objectMapper.readValue(jsonString, this.getTypeToSerialize());
        }
        catch (Exception e) {
            LOGGER.error("Cannot read/parse [{}] to deserialize into type [{}]. This may be caused in the absence of a configuration/support module that knows how to interpret the fragment, specially if the fragment describes a CAS registered service definition. Internal parsing error is [{}]", new Object[]{DigestUtils.abbreviate(jsonString), this.getTypeToSerialize(), e.getMessage()});
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public PrettyPrinter getPrettyPrinter() {
        return this.prettyPrinter;
    }

    @Generated
    protected AbstractJacksonBackedStringSerializer(ObjectMapper objectMapper, PrettyPrinter prettyPrinter) {
        this.objectMapper = objectMapper;
        this.prettyPrinter = prettyPrinter;
    }
}

