/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.spring.boot;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.cas.util.spring.boot.ConditionalOnMultiValuedProperty;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class MultiValuedPropertyCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String name = metadata.getAnnotationAttributes(ConditionalOnMultiValuedProperty.class.getName()).get("name").toString();
        List<String> values = List.of((String[])metadata.getAnnotationAttributes(ConditionalOnMultiValuedProperty.class.getName()).get("value"));
        boolean matched = values.stream().allMatch(value -> {
            try {
                String propertyValue = context.getEnvironment().getProperty(name + "." + value);
                return propertyValue != null;
            }
            catch (IllegalArgumentException e) {
                String placeholder = StringUtils.substringBetween((String)e.getMessage(), (String)"\"", (String)"\"");
                if (placeholder.startsWith("${")) {
                    String propertyValue = SpringExpressionLanguageValueResolver.getInstance().resolve(placeholder);
                    return propertyValue != null;
                }
                throw e;
            }
        });
        if (matched) {
            return ConditionOutcome.match((String)("Found matching property for " + name));
        }
        return ConditionOutcome.noMatch((String)("Could not find matching property for " + name));
    }
}

