/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.ssl;

import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apereo.cas.configuration.model.core.util.ClientCertificateProperties;
import org.apereo.cas.util.RandomUtils;

public final class SSLUtils {
    public static KeyManagerFactory buildKeystore(ClientCertificateProperties properties) {
        KeyManagerFactory keyManagerFactory;
        block8: {
            InputStream keyInput = properties.getCertificate().getLocation().getInputStream();
            try {
                KeyManagerFactory keyManagerFactory2 = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(keyInput, properties.getPassphrase().toCharArray());
                keyManagerFactory2.init(keyStore, properties.getPassphrase().toCharArray());
                keyManagerFactory = keyManagerFactory2;
                if (keyInput == null) break block8;
            }
            catch (Throwable throwable) {
                if (keyInput != null) {
                    try {
                        keyInput.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            keyInput.close();
        }
        return keyManagerFactory;
    }

    public static SSLContext buildSSLContext(ClientCertificateProperties clientCertificate) {
        KeyManagerFactory keyManagerFactory = SSLUtils.buildKeystore(clientCertificate);
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(keyManagerFactory.getKeyManagers(), null, RandomUtils.getNativeInstance());
        return context;
    }

    @Generated
    private SSLUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

