/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import java.net.URL;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;

public final class CasVersion {
    private static final String IMPLEMENTATION_DATE = CasRuntimeHintsRegistrar.inNativeImage() ? ZonedDateTime.now(Clock.systemUTC()).toString() : (String)FunctionUtils.doAndHandle(() -> {
        String className = CasVersion.class.getSimpleName() + ".class";
        String classPath = CasVersion.class.getResource(className).toString();
        String manifestPath = classPath.substring(0, classPath.lastIndexOf(33) + 1) + "/META-INF/MANIFEST.MF";
        Manifest manifest = new Manifest(new URL(manifestPath).openStream());
        Attributes attributes = manifest.getMainAttributes();
        return (String)StringUtils.defaultIfBlank((CharSequence)attributes.getValue("Implementation-Date"), (CharSequence)ZonedDateTime.now(Clock.systemUTC()).toString());
    });

    public static String asString() {
        return CasVersion.getVersion() + " - " + CasVersion.getSpecificationVersion();
    }

    public static String getVersion() {
        return CasVersion.class.getPackage().getImplementationVersion();
    }

    public static String getSpecificationVersion() {
        return CasVersion.class.getPackage().getSpecificationVersion();
    }

    public static ZonedDateTime getDateTime() {
        return DateTimeUtils.zonedDateTimeOf(IMPLEMENTATION_DATE);
    }

    @Generated
    private CasVersion() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

