/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.validation.config;

import java.util.List;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.ticket.proxy.support.Cas10ProxyHandler;
import org.apereo.cas.ticket.proxy.support.Cas20ProxyHandler;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.validation.AuthenticationPolicyAwareServiceTicketValidationAuthorizer;
import org.apereo.cas.validation.Cas10ProtocolValidationSpecification;
import org.apereo.cas.validation.Cas20ProtocolValidationSpecification;
import org.apereo.cas.validation.Cas20WithoutProxyingValidationSpecification;
import org.apereo.cas.validation.CasProtocolValidationSpecification;
import org.apereo.cas.validation.DefaultServiceTicketValidationAuthorizersExecutionPlan;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizer;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizerConfigurer;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizersExecutionPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;

@Configuration(value="CasCoreValidationConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCoreValidationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreValidationConfiguration.class);

    @Configuration(value="CasCoreValidationAuthorizerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreValidationAuthorizerConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"casCoreServiceTicketValidationAuthorizerConfigurer"})
        public ServiceTicketValidationAuthorizerConfigurer casCoreServiceTicketValidationAuthorizerConfigurer(@Qualifier(value="authenticationPolicyAwareServiceTicketValidationAuthorizer") ServiceTicketValidationAuthorizer authenticationPolicyAwareServiceTicketValidationAuthorizer) {
            return plan -> plan.registerAuthorizer(authenticationPolicyAwareServiceTicketValidationAuthorizer);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"authenticationPolicyAwareServiceTicketValidationAuthorizer"})
        public ServiceTicketValidationAuthorizer authenticationPolicyAwareServiceTicketValidationAuthorizer(ConfigurableApplicationContext applicationContext, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="authenticationEventExecutionPlan") AuthenticationEventExecutionPlan authenticationEventExecutionPlan) {
            return new AuthenticationPolicyAwareServiceTicketValidationAuthorizer(servicesManager, authenticationEventExecutionPlan, applicationContext);
        }
    }

    @Configuration(value="CasCoreValidationExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreValidationExecutionPlanConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"serviceValidationAuthorizers"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceTicketValidationAuthorizersExecutionPlan serviceValidationAuthorizers(List<ServiceTicketValidationAuthorizerConfigurer> configurers) {
            DefaultServiceTicketValidationAuthorizersExecutionPlan plan = new DefaultServiceTicketValidationAuthorizersExecutionPlan();
            configurers.forEach(c -> {
                LOGGER.trace("Configuring service ticket validation authorizer execution plan [{}]", (Object)c.getName());
                c.configureAuthorizersExecutionPlan((ServiceTicketValidationAuthorizersExecutionPlan)plan);
            });
            return plan;
        }
    }

    @Configuration(value="CasCoreValidationSpecificationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreValidationSpecificationConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Scope(value="prototype")
        @ConditionalOnMissingBean(name={"cas10ProtocolValidationSpecification"})
        public CasProtocolValidationSpecification cas10ProtocolValidationSpecification(@Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new Cas10ProtocolValidationSpecification(servicesManager);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Scope(value="prototype")
        @ConditionalOnMissingBean(name={"cas20ProtocolValidationSpecification"})
        public CasProtocolValidationSpecification cas20ProtocolValidationSpecification(@Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new Cas20ProtocolValidationSpecification(servicesManager);
        }

        @Bean
        @Scope(value="prototype")
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"cas20WithoutProxyProtocolValidationSpecification"})
        public CasProtocolValidationSpecification cas20WithoutProxyProtocolValidationSpecification(@Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new Cas20WithoutProxyingValidationSpecification(servicesManager);
        }
    }

    @Configuration(value="CasCoreValidationProxyConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreValidationProxyConfiguration {
        @ConditionalOnMissingBean(name={"proxy10Handler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnProperty(prefix="cas.sso", name={"proxy-authn-enabled"}, havingValue="true", matchIfMissing=true)
        public ProxyHandler proxy10Handler() {
            return new Cas10ProxyHandler();
        }

        @ConditionalOnMissingBean(name={"proxy20Handler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnProperty(prefix="cas.sso", name={"proxy-authn-enabled"}, havingValue="true", matchIfMissing=true)
        public ProxyHandler proxy20Handler(@Qualifier(value="proxy20TicketUniqueIdGenerator") UniqueTicketIdGenerator proxy20TicketUniqueIdGenerator, @Qualifier(value="supportsTrustStoreSslSocketFactoryHttpClient") HttpClient httpClient) {
            return new Cas20ProxyHandler(httpClient, proxy20TicketUniqueIdGenerator);
        }
    }
}

