/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.authentication;

import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionCatalog;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionHandler;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.message.MessageResolver;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DefaultCasWebflowAbstractTicketExceptionHandler
implements CasWebflowExceptionHandler<AbstractTicketException> {
    private final CasWebflowExceptionCatalog errors;
    private final String messageBundlePrefix;
    private int order = 0x7FFFFFFE;

    @Override
    public Event handle(AbstractTicketException exception, RequestContext requestContext) {
        String id = this.handleAbstractTicketException(exception, requestContext);
        return new EventFactorySupport().event((Object)this, id);
    }

    @Override
    public boolean supports(Exception exception, RequestContext requestContext) {
        return exception instanceof AbstractTicketException;
    }

    protected String handleAbstractTicketException(AbstractTicketException e, RequestContext requestContext) {
        MessageContext messageContext = requestContext.getMessageContext();
        Optional<String> match = this.errors.getRegisteredExceptions().stream().filter(ex -> ex.isInstance(e)).map(Class::getSimpleName).findFirst();
        MessageResolver msg = new MessageBuilder().error().code(e.getCode()).args(e.getArgs().toArray()).build();
        match.ifPresent(s -> messageContext.addMessage(msg));
        return match.orElse("UNKNOWN");
    }

    @Generated
    public CasWebflowExceptionCatalog getErrors() {
        return this.errors;
    }

    @Generated
    public String getMessageBundlePrefix() {
        return this.messageBundlePrefix;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public DefaultCasWebflowAbstractTicketExceptionHandler(CasWebflowExceptionCatalog errors, String messageBundlePrefix) {
        this.errors = errors;
        this.messageBundlePrefix = messageBundlePrefix;
    }
}

