/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.authentication;

import java.net.URI;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.services.UnauthorizedServiceForPrincipalException;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionCatalog;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionHandler;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DefaultCasWebflowAuthenticationExceptionHandler
implements CasWebflowExceptionHandler<AuthenticationException> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasWebflowAuthenticationExceptionHandler.class);
    private final CasWebflowExceptionCatalog errors;
    private final String messageBundlePrefix;
    private int order = 0x7FFFFFFE;

    @Override
    public Event handle(AuthenticationException exception, RequestContext requestContext) {
        String id = this.handleAuthenticationException(exception, requestContext);
        return new EventFactorySupport().event((Object)this, id);
    }

    @Override
    public boolean supports(Exception exception, RequestContext requestContext) {
        return exception instanceof AuthenticationException;
    }

    protected String handleAuthenticationException(AuthenticationException exception, RequestContext requestContext) {
        URI url;
        if (exception.getHandlerErrors().containsKey(UnauthorizedServiceForPrincipalException.class.getSimpleName()) && (url = WebUtils.getUnauthorizedRedirectUrlFromFlowScope((RequestContext)requestContext)) != null) {
            LOGGER.warn("Unauthorized service access for principal; CAS will be redirecting to [{}]", (Object)url);
            return "serviceUnauthorizedCheck";
        }
        List<Class> values = exception.getHandlerErrors().values().stream().map(Object::getClass).toList();
        String handlerErrorName = this.errors.getRegisteredExceptions().stream().filter(values::contains).map(Class::getSimpleName).findFirst().orElseGet(() -> {
            LOGGER.debug("Unable to translate handler errors of the authentication exception [{}]. Returning [{}]", (Object)exception, (Object)"UNKNOWN");
            return "UNKNOWN";
        });
        String messageCode = this.messageBundlePrefix + handlerErrorName;
        WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)messageCode, (String)"", (Object[])exception.getArgs().toArray());
        return handlerErrorName;
    }

    @Generated
    public CasWebflowExceptionCatalog getErrors() {
        return this.errors;
    }

    @Generated
    public String getMessageBundlePrefix() {
        return this.messageBundlePrefix;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public DefaultCasWebflowAuthenticationExceptionHandler(CasWebflowExceptionCatalog errors, String messageBundlePrefix) {
        this.errors = errors;
        this.messageBundlePrefix = messageBundlePrefix;
    }
}

