/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.authentication;

import lombok.Generated;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionCatalog;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.message.MessageResolver;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class GenericCasWebflowExceptionHandler
implements CasWebflowExceptionHandler<Exception> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericCasWebflowExceptionHandler.class);
    private final CasWebflowExceptionCatalog errors;
    private final String messageBundlePrefix;
    private int order = Integer.MAX_VALUE;

    @Override
    public Event handle(Exception exception, RequestContext requestContext) {
        MessageContext messageContext = requestContext.getMessageContext();
        LOGGER.trace("Unable to translate errors of the authentication exception [{}]. Returning [{}]", (Object)exception, (Object)"UNKNOWN");
        MessageResolver message = this.buildErrorMessageResolver(exception, requestContext);
        messageContext.addMessage(message);
        return new EventFactorySupport().event((Object)this, "UNKNOWN");
    }

    @Override
    public boolean supports(Exception exception, RequestContext requestContext) {
        return exception != null;
    }

    protected MessageResolver buildErrorMessageResolver(Exception exception, RequestContext requestContext) {
        String messageCode = this.messageBundlePrefix + "UNKNOWN";
        return new MessageBuilder().error().code(messageCode).build();
    }

    @Generated
    public CasWebflowExceptionCatalog getErrors() {
        return this.errors;
    }

    @Generated
    public String getMessageBundlePrefix() {
        return this.messageBundlePrefix;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public GenericCasWebflowExceptionHandler(CasWebflowExceptionCatalog errors, String messageBundlePrefix) {
        this.errors = errors;
        this.messageBundlePrefix = messageBundlePrefix;
    }
}

