/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.SingleSignOnParticipationRequest;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.resolver.impl.AbstractCasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ServiceTicketRequestWebflowEventResolver
extends AbstractCasWebflowEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceTicketRequestWebflowEventResolver.class);

    public ServiceTicketRequestWebflowEventResolver(CasWebflowEventResolutionConfigurationContext context) {
        super(context);
    }

    @Override
    public Set<Event> resolveInternal(RequestContext context) throws Throwable {
        if (this.isRequestAskingForServiceTicket(context)) {
            LOGGER.trace("Authentication request is asking for service tickets");
            Event source = this.grantServiceTicket(context);
            return Optional.ofNullable(source).map(CollectionUtils::wrapSet).orElse(null);
        }
        return null;
    }

    protected boolean isRequestAskingForServiceTicket(RequestContext context) throws Throwable {
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        LOGGER.trace("Located ticket-granting ticket [{}] from the request context", (Object)ticketGrantingTicketId);
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        LOGGER.trace("Located service [{}] from the request context", (Object)service);
        CasWebflowEventResolutionConfigurationContext configContext = this.getConfigurationContext();
        if (service != null && StringUtils.isNotBlank((CharSequence)ticketGrantingTicketId)) {
            Authentication authn = configContext.getTicketRegistrySupport().getAuthenticationFrom(ticketGrantingTicketId);
            LOGGER.debug("Request identifies itself as one asking for service tickets. Checking for authentication context validity...");
            boolean validAuthn = this.validateExistingAuthentication(authn, context);
            if (validAuthn) {
                LOGGER.debug("Existing authentication context linked to ticket-granting ticket [{}] is valid. CAS will try to issue service tickets for [{}] once credentials are renewed", (Object)ticketGrantingTicketId, (Object)service);
                return true;
            }
            LOGGER.debug("Existing authentication context linked to ticket-granting ticket [{}] is NOT valid. CAS will not issue service tickets for [{}] just yet without renewing the authentication context", (Object)ticketGrantingTicketId, (Object)service);
            return false;
        }
        LOGGER.debug("Request is not eligible to be issued service tickets just yet");
        return false;
    }

    protected Event grantServiceTicket(RequestContext context) throws Throwable {
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        List<Credential> credentials = this.getCredentialFromContext(context);
        try {
            WebApplicationService service = WebUtils.getService((RequestContext)context);
            CasWebflowEventResolutionConfigurationContext configContext = this.getConfigurationContext();
            Authentication existingAuthn = configContext.getTicketRegistrySupport().getAuthenticationFrom(ticketGrantingTicketId);
            RegisteredService registeredService = configContext.getServicesManager().findServiceBy((Service)service);
            if (existingAuthn != null && registeredService != null) {
                LOGGER.debug("Enforcing access strategy policies for registered service [{}] and principal [{}]", (Object)registeredService, (Object)existingAuthn.getPrincipal());
                AuditableContext audit = AuditableContext.builder().service((Service)service).authentication(existingAuthn).registeredService(registeredService).build();
                AuditableExecutionResult accessResult = configContext.getRegisteredServiceAccessStrategyEnforcer().execute(audit);
                accessResult.throwExceptionIfNeeded();
            }
            Principal principal = this.getActivePrincipal(credentials, service, existingAuthn);
            LOGGER.debug("Primary principal for this authentication session to receive a service ticket is [{}]", (Object)principal);
            if (existingAuthn != null && !existingAuthn.getPrincipal().equals((Object)principal)) {
                LOGGER.trace("Existing authentication context linked to ticket-granting ticket [{}] is issued for principal [{}]  which does not match [{}], established by the requested authentication transaction. CAS will NOT re-use the existing authentication context to issue service tickets", new Object[]{ticketGrantingTicketId, existingAuthn.getPrincipal(), principal});
                return null;
            }
            return this.newEvent("generateServiceTicket");
        }
        catch (AuthenticationException | AbstractTicketException e) {
            LOGGER.trace(e.getMessage(), e);
            return this.newEvent("authenticationFailure", e);
        }
    }

    private boolean validateExistingAuthentication(Authentication authentication, RequestContext requestContext) throws Throwable {
        if (authentication != null) {
            SingleSignOnParticipationRequest ssoRequest;
            CasWebflowEventResolutionConfigurationContext configContext = this.getConfigurationContext();
            SingleSignOnParticipationStrategy ssoStrategy = configContext.getSingleSignOnParticipationStrategy();
            if (ssoStrategy.supports(ssoRequest = SingleSignOnParticipationRequest.builder().requestContext(requestContext).build()) && !ssoStrategy.isParticipating(ssoRequest)) {
                LOGGER.debug("Single sign-on strategy does not allow reusing the authentication attempt [{}]", (Object)authentication);
                return false;
            }
            LOGGER.trace("Existing authentication attempt [{}] is valid", (Object)authentication);
            return true;
        }
        LOGGER.trace("Cannot validate absent/missing authentication attempt");
        return false;
    }

    protected Principal getActivePrincipal(List<Credential> credential, WebApplicationService service, Authentication authentication) throws Throwable {
        if (credential != null && !credential.isEmpty()) {
            LOGGER.trace("Finalizing authentication transaction for [{}]", credential);
            AuthenticationResult authenticationResult = this.getConfigurationContext().getAuthenticationSystemSupport().finalizeAuthenticationTransaction((Service)service, credential);
            return authenticationResult.getAuthentication().getPrincipal();
        }
        return Objects.requireNonNull(authentication).getPrincipal();
    }
}

