/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.configurer;

import java.util.Collection;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class CompositeProviderSelectionMultifactorWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    public CompositeProviderSelectionMultifactorWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        this.setOrder(Integer.MAX_VALUE);
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            TransitionableState realSubmit = this.getState(flow, "realSubmit");
            this.createTransitionForState(realSubmit, "mfa-composite", "mfa-composite");
            TransitionableState delegation = this.getState(flow, "delegatedAuthentication");
            FunctionUtils.doIfNotNull((Object)delegation, u -> this.createTransitionForState(delegation, "mfa-composite", "mfa-composite"));
            TransitionableState initialAuthn = this.getState(flow, "initialAuthenticationRequestValidationCheck");
            this.createTransitionForState(initialAuthn, "mfa-composite", "mfa-composite");
            ViewState viewState = this.createViewState(flow, "mfa-composite", "mfa/casCompositeMfaProviderSelectionView");
            viewState.getEntryActionList().add((Action)this.createEvaluateAction("prepareMultifactorProviderSelectionAction"));
            this.createTransitionForState((TransitionableState)viewState, "submit", "compositeMfaProviderSelectedAction");
            ActionState selectedState = this.createActionState(flow, "compositeMfaProviderSelectedAction", (Action)this.createEvaluateAction("multifactorProviderSelectedAction"));
            Collection providers = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext).values();
            providers.forEach(p -> this.createTransitionForState((TransitionableState)selectedState, p.getId(), p.getId()));
        }
    }
}

