/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.config;

import java.util.List;
import org.apereo.cas.authentication.DefaultMultifactorAuthenticationProviderResolver;
import org.apereo.cas.authentication.DefaultMultifactorAuthenticationTriggerSelectionStrategy;
import org.apereo.cas.authentication.MultifactorAuthenticationContextValidator;
import org.apereo.cas.authentication.MultifactorAuthenticationFailureModeEvaluator;
import org.apereo.cas.authentication.MultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderResolver;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.MultifactorAuthenticationTriggerSelectionStrategy;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.authentication.mfa.trigger.AdaptiveMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.trigger.AuthenticationAttributeMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.trigger.GlobalMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.trigger.GroovyScriptMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.trigger.HttpRequestMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.trigger.PredicatedPrincipalAttributeMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.trigger.PrincipalAttributeMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.trigger.RegisteredServiceMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.trigger.RegisteredServicePrincipalAttributeMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.trigger.RestEndpointMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.trigger.ScriptedRegisteredServiceMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.trigger.TimedMultifactorAuthenticationTrigger;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.SpringResourceProperties;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProperties;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.actions.MultifactorAuthenticationAvailableAction;
import org.apereo.cas.web.flow.actions.MultifactorAuthenticationBypassAction;
import org.apereo.cas.web.flow.actions.MultifactorAuthenticationFailureAction;
import org.apereo.cas.web.flow.actions.composite.MultifactorProviderSelectedAction;
import org.apereo.cas.web.flow.actions.composite.PrepareMultifactorProviderSelectionAction;
import org.apereo.cas.web.flow.authentication.ChainingMultifactorAuthenticationProviderSelector;
import org.apereo.cas.web.flow.authentication.GroovyScriptMultifactorAuthenticationProviderSelector;
import org.apereo.cas.web.flow.authentication.RankedMultifactorAuthenticationProviderSelector;
import org.apereo.cas.web.flow.configurer.CompositeProviderSelectionMultifactorWebflowConfigurer;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.resolver.impl.CompositeProviderSelectionMultifactorWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.DefaultCasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.RankedMultifactorAuthenticationProviderWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.SelectiveMultifactorAuthenticationProviderWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.mfa.DefaultMultifactorAuthenticationProviderWebflowEventResolver;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="CasMultifactorAuthenticationWebflowConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnWebApplication
public class CasMultifactorAuthenticationWebflowConfiguration {

    @Configuration(value="CasCoreMultifactorAuthenticationProviderCompositeConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnProperty(prefix="cas.authn.mfa.core", name={"provider-selection-enabled"}, havingValue="true")
    public static class CasCoreMultifactorAuthenticationProviderCompositeConfiguration {
        @ConditionalOnMissingBean(name={"selectiveAuthenticationProviderWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver selectiveAuthenticationProviderWebflowEventResolver(@Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new CompositeProviderSelectionMultifactorWebflowEventResolver(casWebflowConfigurationContext);
        }

        @Bean
        @ConditionalOnMissingBean(name={"compositeProviderSelectionMultifactorWebflowConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer compositeProviderSelectionMultifactorWebflowConfigurer(@Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return new CompositeProviderSelectionMultifactorWebflowConfigurer(flowBuilderServices, loginFlowRegistry, applicationContext, casProperties);
        }

        @Bean
        @ConditionalOnMissingBean(name={"compositeProviderSelectionCasWebflowExecutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExecutionPlanConfigurer compositeProviderSelectionCasWebflowExecutionPlanConfigurer(@Qualifier(value="compositeProviderSelectionMultifactorWebflowConfigurer") CasWebflowConfigurer compositeProviderSelectionMultifactorWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(compositeProviderSelectionMultifactorWebflowConfigurer);
        }
    }

    @Configuration(value="CasCoreMultifactorAuthenticationProviderSelectiveConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnProperty(prefix="cas.authn.mfa.core", name={"provider-selection-enabled"}, havingValue="false", matchIfMissing=true)
    public static class CasCoreMultifactorAuthenticationProviderSelectiveConfiguration {
        @ConditionalOnMissingBean(name={"selectiveAuthenticationProviderWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver selectiveAuthenticationProviderWebflowEventResolver(@Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new SelectiveMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext);
        }
    }

    @Configuration(value="CasMultifactorAuthenticationWebflowActionsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasMultifactorAuthenticationWebflowActionsConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"mfaAvailableAction"})
        public Action mfaAvailableAction() {
            return new MultifactorAuthenticationAvailableAction();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"mfaBypassAction"})
        public Action mfaBypassAction() {
            return new MultifactorAuthenticationBypassAction();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"mfaFailureAction"})
        public Action mfaFailureAction() {
            return new MultifactorAuthenticationFailureAction();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"multifactorProviderSelectedAction"})
        public Action multifactorProviderSelectedAction() {
            return new MultifactorProviderSelectedAction();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"prepareMultifactorProviderSelectionAction"})
        public Action prepareMultifactorProviderSelectionAction() {
            return new PrepareMultifactorProviderSelectionAction();
        }
    }

    @Configuration(value="CasMultifactorAuthenticationWebflowContextConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasMultifactorAuthenticationWebflowContextConfiguration {
        @ConditionalOnMissingBean(name={"initialAuthenticationAttemptWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver(@Qualifier(value="selectiveAuthenticationProviderWebflowEventResolver") CasWebflowEventResolver selectiveAuthenticationProviderWebflowEventResolver, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext, @Qualifier(value="adaptiveAuthenticationPolicyWebflowEventResolver") CasWebflowEventResolver adaptiveAuthenticationPolicyWebflowEventResolver, @Qualifier(value="timedAuthenticationPolicyWebflowEventResolver") CasWebflowEventResolver timedAuthenticationPolicyWebflowEventResolver, @Qualifier(value="globalAuthenticationPolicyWebflowEventResolver") CasWebflowEventResolver globalAuthenticationPolicyWebflowEventResolver, @Qualifier(value="httpRequestAuthenticationPolicyWebflowEventResolver") CasWebflowEventResolver httpRequestAuthenticationPolicyWebflowEventResolver, @Qualifier(value="restEndpointAuthenticationPolicyWebflowEventResolver") CasWebflowEventResolver restEndpointAuthenticationPolicyWebflowEventResolver, @Qualifier(value="groovyScriptAuthenticationPolicyWebflowEventResolver") CasWebflowEventResolver groovyScriptAuthenticationPolicyWebflowEventResolver, @Qualifier(value="scriptedRegisteredServiceAuthenticationPolicyWebflowEventResolver") CasWebflowEventResolver scriptedRegisteredServiceAuthenticationPolicyWebflowEventResolver, @Qualifier(value="registeredServicePrincipalAttributeAuthenticationPolicyWebflowEventResolver") CasWebflowEventResolver registeredServicePrincipalAttributeAuthenticationPolicyWebflowEventResolver, @Qualifier(value="predicatedPrincipalAttributeMultifactorAuthenticationPolicyEventResolver") CasWebflowEventResolver predicatedPrincipalAttributeMultifactorAuthenticationPolicyEventResolver, @Qualifier(value="principalAttributeAuthenticationPolicyWebflowEventResolver") CasWebflowEventResolver principalAttributeAuthenticationPolicyWebflowEventResolver, @Qualifier(value="authenticationAttributeAuthenticationPolicyWebflowEventResolver") CasWebflowEventResolver authenticationAttributeAuthenticationPolicyWebflowEventResolver, @Qualifier(value="registeredServiceAuthenticationPolicyWebflowEventResolver") CasWebflowEventResolver registeredServiceAuthenticationPolicyWebflowEventResolver) {
            DefaultCasDelegatingWebflowEventResolver resolver = new DefaultCasDelegatingWebflowEventResolver(casWebflowConfigurationContext, selectiveAuthenticationProviderWebflowEventResolver);
            resolver.addDelegate(adaptiveAuthenticationPolicyWebflowEventResolver);
            resolver.addDelegate(timedAuthenticationPolicyWebflowEventResolver);
            resolver.addDelegate(globalAuthenticationPolicyWebflowEventResolver);
            resolver.addDelegate(httpRequestAuthenticationPolicyWebflowEventResolver);
            resolver.addDelegate(restEndpointAuthenticationPolicyWebflowEventResolver);
            resolver.addDelegate(groovyScriptAuthenticationPolicyWebflowEventResolver);
            resolver.addDelegate(scriptedRegisteredServiceAuthenticationPolicyWebflowEventResolver);
            resolver.addDelegate(registeredServicePrincipalAttributeAuthenticationPolicyWebflowEventResolver);
            resolver.addDelegate(predicatedPrincipalAttributeMultifactorAuthenticationPolicyEventResolver);
            resolver.addDelegate(principalAttributeAuthenticationPolicyWebflowEventResolver);
            resolver.addDelegate(authenticationAttributeAuthenticationPolicyWebflowEventResolver);
            resolver.addDelegate(registeredServiceAuthenticationPolicyWebflowEventResolver);
            return resolver;
        }
    }

    @Configuration(value="CasMultifactorAuthenticationWebflowSelectorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasMultifactorAuthenticationWebflowSelectorConfiguration {
        @ConditionalOnMissingBean(name={"multifactorAuthenticationProviderSelector"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationProviderSelector multifactorAuthenticationProviderSelector(@Qualifier(value="failureModeEvaluator") MultifactorAuthenticationFailureModeEvaluator failureModeEvaluator, CasConfigurationProperties casProperties) {
            MultifactorAuthenticationProperties mfa = casProperties.getAuthn().getMfa();
            SpringResourceProperties script = mfa.getCore().getProviderSelectorGroovyScript();
            if (script.getLocation() != null) {
                return new GroovyScriptMultifactorAuthenticationProviderSelector(script.getLocation());
            }
            if (mfa.getCore().isProviderSelectionEnabled()) {
                return new ChainingMultifactorAuthenticationProviderSelector(failureModeEvaluator);
            }
            return new RankedMultifactorAuthenticationProviderSelector();
        }
    }

    @Configuration(value="CasMultifactorAuthenticationWebflowResolverConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasMultifactorAuthenticationWebflowResolverConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"multifactorAuthenticationProviderResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationProviderResolver multifactorAuthenticationProviderResolver(List<MultifactorAuthenticationPrincipalResolver> resolvers) {
            AnnotationAwareOrderComparator.sort(resolvers);
            return new DefaultMultifactorAuthenticationProviderResolver(resolvers);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"defaultMultifactorAuthenticationPrincipalResolver"})
        public MultifactorAuthenticationPrincipalResolver defaultMultifactorAuthenticationPrincipalResolver() {
            return MultifactorAuthenticationPrincipalResolver.identical();
        }
    }

    @Configuration(value="CasMultifactorAuthenticationWebflowTriggersConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasMultifactorAuthenticationWebflowTriggersConfiguration {
        @ConditionalOnMissingBean(name={"groovyScriptAuthenticationPolicyWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver groovyScriptAuthenticationPolicyWebflowEventResolver(@Qualifier(value="groovyScriptMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger groovyScriptMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, groovyScriptMultifactorAuthenticationTrigger);
        }

        @ConditionalOnMissingBean(name={"httpRequestAuthenticationPolicyWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver httpRequestAuthenticationPolicyWebflowEventResolver(@Qualifier(value="httpRequestMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger httpRequestMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, httpRequestMultifactorAuthenticationTrigger);
        }

        @ConditionalOnMissingBean(name={"restEndpointAuthenticationPolicyWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver restEndpointAuthenticationPolicyWebflowEventResolver(@Qualifier(value="restEndpointMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger restEndpointMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, restEndpointMultifactorAuthenticationTrigger);
        }

        @ConditionalOnMissingBean(name={"globalAuthenticationPolicyWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver globalAuthenticationPolicyWebflowEventResolver(@Qualifier(value="globalMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger globalMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, globalMultifactorAuthenticationTrigger);
        }

        @ConditionalOnMissingBean(name={"adaptiveAuthenticationPolicyWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver adaptiveAuthenticationPolicyWebflowEventResolver(@Qualifier(value="adaptiveMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger adaptiveMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, adaptiveMultifactorAuthenticationTrigger);
        }

        @ConditionalOnMissingBean(name={"registeredServiceAuthenticationPolicyWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver registeredServiceAuthenticationPolicyWebflowEventResolver(@Qualifier(value="registeredServiceMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger registeredServiceMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, registeredServiceMultifactorAuthenticationTrigger);
        }

        @ConditionalOnMissingBean(name={"predicatedPrincipalAttributeMultifactorAuthenticationPolicyEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver predicatedPrincipalAttributeMultifactorAuthenticationPolicyEventResolver(@Qualifier(value="predicatedPrincipalAttributeMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger predicatedPrincipalAttributeMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, predicatedPrincipalAttributeMultifactorAuthenticationTrigger);
        }

        @ConditionalOnMissingBean(name={"principalAttributeAuthenticationPolicyWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver principalAttributeAuthenticationPolicyWebflowEventResolver(@Qualifier(value="principalAttributeMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger principalAttributeMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, principalAttributeMultifactorAuthenticationTrigger);
        }

        @ConditionalOnMissingBean(name={"scriptedRegisteredServiceAuthenticationPolicyWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Deprecated(since="6.2.0")
        public CasWebflowEventResolver scriptedRegisteredServiceAuthenticationPolicyWebflowEventResolver(@Qualifier(value="scriptedRegisteredServiceMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger scriptedRegisteredServiceMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, scriptedRegisteredServiceMultifactorAuthenticationTrigger);
        }

        @ConditionalOnMissingBean(name={"timedAuthenticationPolicyWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver timedAuthenticationPolicyWebflowEventResolver(@Qualifier(value="timedMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger timedMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, timedMultifactorAuthenticationTrigger);
        }

        @ConditionalOnMissingBean(name={"registeredServicePrincipalAttributeAuthenticationPolicyWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver registeredServicePrincipalAttributeAuthenticationPolicyWebflowEventResolver(@Qualifier(value="registeredServicePrincipalAttributeMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger registeredServicePrincipalAttributeMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, registeredServicePrincipalAttributeMultifactorAuthenticationTrigger);
        }

        @ConditionalOnMissingBean(name={"authenticationAttributeAuthenticationPolicyWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver authenticationAttributeAuthenticationPolicyWebflowEventResolver(@Qualifier(value="authenticationAttributeMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger authenticationAttributeMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, authenticationAttributeMultifactorAuthenticationTrigger);
        }

        @Bean
        @ConditionalOnMissingBean(name={"scriptedRegisteredServiceMultifactorAuthenticationTrigger"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Deprecated(since="6.2.0")
        public MultifactorAuthenticationTrigger scriptedRegisteredServiceMultifactorAuthenticationTrigger(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new ScriptedRegisteredServiceMultifactorAuthenticationTrigger(casProperties, (ApplicationContext)applicationContext);
        }

        @Bean
        @ConditionalOnMissingBean(name={"registeredServicePrincipalAttributeMultifactorAuthenticationTrigger"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger registeredServicePrincipalAttributeMultifactorAuthenticationTrigger(@Qualifier(value="multifactorAuthenticationProviderSelector") MultifactorAuthenticationProviderSelector multifactorAuthenticationProviderSelector, @Qualifier(value="multifactorAuthenticationProviderResolver") MultifactorAuthenticationProviderResolver multifactorAuthenticationProviderResolver, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new RegisteredServicePrincipalAttributeMultifactorAuthenticationTrigger(casProperties, multifactorAuthenticationProviderResolver, (ApplicationContext)applicationContext, multifactorAuthenticationProviderSelector);
        }

        @Bean
        @ConditionalOnMissingBean(name={"restEndpointMultifactorAuthenticationTrigger"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger restEndpointMultifactorAuthenticationTrigger(@Qualifier(value="multifactorAuthenticationProviderResolver") MultifactorAuthenticationProviderResolver multifactorAuthenticationProviderResolver, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new RestEndpointMultifactorAuthenticationTrigger(casProperties, multifactorAuthenticationProviderResolver, (ApplicationContext)applicationContext);
        }

        @Bean
        @ConditionalOnMissingBean(name={"registeredServiceMultifactorAuthenticationTrigger"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger registeredServiceMultifactorAuthenticationTrigger(@Qualifier(value="multifactorAuthenticationProviderSelector") MultifactorAuthenticationProviderSelector multifactorAuthenticationProviderSelector, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new RegisteredServiceMultifactorAuthenticationTrigger(casProperties, multifactorAuthenticationProviderSelector, applicationContext);
        }

        @ConditionalOnMissingBean(name={"adaptiveMultifactorAuthenticationTrigger"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger adaptiveMultifactorAuthenticationTrigger(@Qualifier(value="geoLocationService") ObjectProvider<GeoLocationService> geoLocationService, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new AdaptiveMultifactorAuthenticationTrigger((GeoLocationService)geoLocationService.getIfAvailable(), casProperties, (ApplicationContext)applicationContext);
        }

        @ConditionalOnMissingBean(name={"globalMultifactorAuthenticationTrigger"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger globalMultifactorAuthenticationTrigger(@Qualifier(value="multifactorAuthenticationProviderSelector") MultifactorAuthenticationProviderSelector multifactorAuthenticationProviderSelector, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new GlobalMultifactorAuthenticationTrigger(casProperties, (ApplicationContext)applicationContext, multifactorAuthenticationProviderSelector);
        }

        @Bean
        @ConditionalOnMissingBean(name={"timedMultifactorAuthenticationTrigger"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger timedMultifactorAuthenticationTrigger(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new TimedMultifactorAuthenticationTrigger(casProperties, (ApplicationContext)applicationContext);
        }

        @ConditionalOnMissingBean(name={"groovyScriptMultifactorAuthenticationTrigger"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger groovyScriptMultifactorAuthenticationTrigger(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new GroovyScriptMultifactorAuthenticationTrigger(casProperties, (ApplicationContext)applicationContext);
        }

        @ConditionalOnMissingBean(name={"httpRequestMultifactorAuthenticationTrigger"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger httpRequestMultifactorAuthenticationTrigger(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new HttpRequestMultifactorAuthenticationTrigger(casProperties, (ApplicationContext)applicationContext);
        }

        @ConditionalOnMissingBean(name={"principalAttributeMultifactorAuthenticationTrigger"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger principalAttributeMultifactorAuthenticationTrigger(@Qualifier(value="multifactorAuthenticationProviderResolver") MultifactorAuthenticationProviderResolver multifactorAuthenticationProviderResolver, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new PrincipalAttributeMultifactorAuthenticationTrigger(casProperties, multifactorAuthenticationProviderResolver, (ApplicationContext)applicationContext);
        }

        @ConditionalOnMissingBean(name={"authenticationAttributeMultifactorAuthenticationTrigger"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger authenticationAttributeMultifactorAuthenticationTrigger(@Qualifier(value="multifactorAuthenticationProviderResolver") MultifactorAuthenticationProviderResolver multifactorAuthenticationProviderResolver, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new AuthenticationAttributeMultifactorAuthenticationTrigger(casProperties, multifactorAuthenticationProviderResolver, (ApplicationContext)applicationContext);
        }

        @Bean
        @ConditionalOnMissingBean(name={"predicatedPrincipalAttributeMultifactorAuthenticationTrigger"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger predicatedPrincipalAttributeMultifactorAuthenticationTrigger(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new PredicatedPrincipalAttributeMultifactorAuthenticationTrigger(casProperties, (ApplicationContext)applicationContext);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"defaultMultifactorTriggerSelectionStrategy"})
        public MultifactorAuthenticationTriggerSelectionStrategy defaultMultifactorTriggerSelectionStrategy(List<MultifactorAuthenticationTrigger> triggers) {
            AnnotationAwareOrderComparator.sortIfNecessary(triggers);
            return new DefaultMultifactorAuthenticationTriggerSelectionStrategy(triggers);
        }
    }

    @Configuration(value="CasMultifactorAuthenticationWebflowRankedEventConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasMultifactorAuthenticationWebflowRankedEventConfiguration {
        @ConditionalOnMissingBean(name={"rankedAuthenticationProviderWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasDelegatingWebflowEventResolver rankedAuthenticationProviderWebflowEventResolver(@Qualifier(value="initialAuthenticationAttemptWebflowEventResolver") CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext, @Qualifier(value="authenticationContextValidator") MultifactorAuthenticationContextValidator authenticationContextValidator, @Qualifier(value="singleSignOnParticipationStrategy") SingleSignOnParticipationStrategy webflowSingleSignOnParticipationStrategy) {
            return new RankedMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, initialAuthenticationAttemptWebflowEventResolver, authenticationContextValidator, webflowSingleSignOnParticipationStrategy);
        }
    }
}

