/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.nativex;

import java.sql.Driver;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;

public class JdbcDriversRuntimeHints
implements CasRuntimeHintsRegistrar {
    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        JdbcDriversRuntimeHints.registerReflectionHints(hints, this.findSubclassesInPackage(Driver.class, new String[]{"com.mysql", "net.sourceforge", "org.h2", "org.mariadb", "org.postgresql", "org.apache.ignite", "org.sqlite", "org.hsqldb", "oracle.jdbc", "com.microsoft"}));
        JdbcDriversRuntimeHints.registerReflectionHints(hints, List.of(TypeReference.of((String)"oracle.jdbc.logging.annotations.Feature"), TypeReference.of((String)"org.hsqldb.dbinfo.DatabaseInformationFull"), TypeReference.of((String)"org.hsqldb.dbinfo.DatabaseInformation")));
        hints.resources().registerResourceBundle("org/hsqldb/resources/sql-state-messages").registerPattern("org/hsqldb/resources/*.sql").registerPattern("org/hsqldb/resources/*.properties");
        JdbcDriversRuntimeHints.registerReflectionHints(hints, List.of(DataSource.class));
    }

    private static void registerReflectionHints(RuntimeHints hints, Collection entries) {
        MemberCategory[] memberCategories = new MemberCategory[]{MemberCategory.INTROSPECT_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.DECLARED_FIELDS, MemberCategory.PUBLIC_FIELDS};
        entries.forEach(el -> {
            if (el instanceof Class) {
                Class clazz = (Class)el;
                hints.reflection().registerType(clazz, memberCategories);
            }
            if (el instanceof TypeReference) {
                TypeReference reference = (TypeReference)el;
                hints.reflection().registerType(reference, memberCategories);
            }
        });
    }
}

