/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.spi.PersistenceProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.sql.DataSource;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigurationContext;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.jpa.JpaBeanFactory;
import org.apereo.cas.jpa.JpaPersistenceProviderConfigurer;
import org.apereo.cas.services.JpaRegisteredServiceEntity;
import org.apereo.cas.services.JpaServiceRegistry;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryExecutionPlanConfigurer;
import org.apereo.cas.services.ServiceRegistryListener;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.jooq.lambda.Unchecked;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.integration.transaction.PseudoTransactionManager;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.transaction.support.TransactionTemplate;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement(proxyTargetClass=false)
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.ServiceRegistry}, module="jpa")
@AutoConfiguration
public class JpaServiceRegistryConfiguration {
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.service-registry.jpa.enabled").isTrue().evenIfMissing();

    @Configuration(value="JpaServiceRegistryBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class JpaServiceRegistryBaseConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"jpaServiceRegistry"})
        public ServiceRegistry jpaServiceRegistry(ConfigurableApplicationContext applicationContext, ObjectProvider<List<ServiceRegistryListener>> serviceRegistryListeners, @Qualifier(value="jdbcServiceRegistryTransactionTemplate") TransactionOperations jdbcServiceRegistryTransactionTemplate) {
            return (ServiceRegistry)BeanSupplier.of(ServiceRegistry.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new JpaServiceRegistry(applicationContext, Optional.ofNullable((List)serviceRegistryListeners.getIfAvailable()).orElseGet(ArrayList::new), jdbcServiceRegistryTransactionTemplate)).otherwiseProxy().get();
        }
    }

    @Configuration(value="JpaServiceRegistryDataConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class JpaServiceRegistryDataConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"dataSourceService"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DataSource dataSourceService(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (DataSource)BeanSupplier.of(DataSource.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> JpaBeans.newDataSource((AbstractJpaProperties)casProperties.getServiceRegistry().getJpa())).otherwiseProxy().get();
        }
    }

    @Configuration(value="JpaServiceRegistryTransactionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class JpaServiceRegistryTransactionConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PlatformTransactionManager transactionManagerServiceReg(ConfigurableApplicationContext applicationContext, @Qualifier(value="serviceEntityManagerFactory") EntityManagerFactory emf) {
            return (PlatformTransactionManager)BeanSupplier.of(PlatformTransactionManager.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                JpaTransactionManager mgmr = new JpaTransactionManager();
                mgmr.setEntityManagerFactory(emf);
                return mgmr;
            }).otherwise(PseudoTransactionManager::new).get();
        }

        @ConditionalOnMissingBean(name={"jdbcServiceRegistryTransactionTemplate"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TransactionOperations jdbcServiceRegistryTransactionTemplate(CasConfigurationProperties casProperties, @Qualifier(value="transactionManagerServiceReg") PlatformTransactionManager transactionManagerServiceReg, ConfigurableApplicationContext applicationContext) {
            return (TransactionOperations)BeanSupplier.of(TransactionOperations.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                TransactionTemplate t = new TransactionTemplate(transactionManagerServiceReg);
                t.setIsolationLevelName(casProperties.getServiceRegistry().getJpa().getIsolationLevelName());
                t.setPropagationBehaviorName(casProperties.getServiceRegistry().getJpa().getPropagationBehaviorName());
                return t;
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="JpaServiceRegistryEntityConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class JpaServiceRegistryEntityConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public JpaVendorAdapter jpaServiceVendorAdapter(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) {
            return (JpaVendorAdapter)BeanSupplier.of(JpaVendorAdapter.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> jpaBeanFactory.newJpaVendorAdapter(casProperties.getJdbc())).otherwiseProxy().get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public PersistenceProvider jpaServicePersistenceProvider(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) {
            return (PersistenceProvider)BeanSupplier.of(PersistenceProvider.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> jpaBeanFactory.newPersistenceProvider((AbstractJpaProperties)casProperties.getServiceRegistry().getJpa())).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"jpaServicePackagesToScan"})
        public BeanContainer<String> jpaServicePackagesToScan() {
            return BeanContainer.of((Set)CollectionUtils.wrapSet((Object)JpaRegisteredServiceEntity.class.getPackage().getName()));
        }

        @Bean
        @ConditionalOnMissingBean(name={"serviceEntityManagerFactory"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public FactoryBean<EntityManagerFactory> serviceEntityManagerFactory(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="dataSourceService") DataSource dataSourceService, @Qualifier(value="jpaServiceVendorAdapter") JpaVendorAdapter jpaServiceVendorAdapter, @Qualifier(value="jpaServicePersistenceProvider") PersistenceProvider jpaServicePersistenceProvider, @Qualifier(value="jpaServicePackagesToScan") BeanContainer<String> jpaServicePackagesToScan, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) throws Exception {
            return (FactoryBean)BeanSupplier.of(FactoryBean.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(Unchecked.supplier(() -> {
                JpaConfigurationContext ctx = JpaConfigurationContext.builder().dataSource(dataSourceService).persistenceUnitName("jpaServiceRegistryContext").jpaVendorAdapter(jpaServiceVendorAdapter).persistenceProvider(jpaServicePersistenceProvider).packagesToScan(jpaServicePackagesToScan.toSet()).build();
                return jpaBeanFactory.newEntityManagerFactoryBean(ctx, (AbstractJpaProperties)casProperties.getServiceRegistry().getJpa());
            })).otherwiseProxy().get();
        }
    }

    @Configuration(value="JpaServiceRegistryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class JpaServiceRegistryPlanConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"jpaServiceRegistryExecutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceRegistryExecutionPlanConfigurer jpaServiceRegistryExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="jpaServiceRegistry") ServiceRegistry jpaServiceRegistry) {
            return (ServiceRegistryExecutionPlanConfigurer)BeanSupplier.of(ServiceRegistryExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerServiceRegistry(jpaServiceRegistry)).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"jpaServicePersistenceProviderConfigurer"})
        public JpaPersistenceProviderConfigurer jpaServicePersistenceProviderConfigurer(ConfigurableApplicationContext applicationContext) {
            return (JpaPersistenceProviderConfigurer)BeanSupplier.of(JpaPersistenceProviderConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> context -> {
                List entities = CollectionUtils.wrapList((Object[])new String[]{JpaRegisteredServiceEntity.class.getName()});
                context.getIncludeEntityClasses().addAll(entities);
            }).otherwiseProxy().get();
        }
    }
}

