/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import lombok.Generated;
import org.apereo.cas.configuration.support.JpaPersistenceUnitProvider;
import org.apereo.cas.services.AbstractServiceRegistry;
import org.apereo.cas.services.JpaRegisteredServiceEntity;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceRegistryListener;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.apereo.cas.support.events.service.CasRegisteredServiceLoadedEvent;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.StringSerializer;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.transaction.support.TransactionOperations;

public class JpaServiceRegistry
extends AbstractServiceRegistry
implements JpaPersistenceUnitProvider {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaServiceRegistry.class);
    public static final String PERSISTENCE_UNIT_NAME = "jpaServiceRegistryContext";
    private final TransactionOperations transactionTemplate;
    @PersistenceContext(unitName="jpaServiceRegistryContext")
    private EntityManager entityManager;
    private final StringSerializer<RegisteredService> serializer;

    public JpaServiceRegistry(ConfigurableApplicationContext applicationContext, Collection<ServiceRegistryListener> serviceRegistryListeners, TransactionOperations transactionTemplate) {
        super(applicationContext, serviceRegistryListeners);
        this.transactionTemplate = transactionTemplate;
        this.serializer = new RegisteredServiceJsonSerializer(applicationContext);
        this.entityManager = this.recreateEntityManagerIfNecessary(PERSISTENCE_UNIT_NAME);
    }

    public boolean delete(RegisteredService registeredService) {
        this.transactionTemplate.executeWithoutResult(__ -> {
            JpaRegisteredServiceEntity entity = this.fromRegisteredService(registeredService);
            if (this.entityManager.contains((Object)entity)) {
                this.entityManager.remove((Object)entity);
            } else {
                this.entityManager.remove(this.entityManager.merge((Object)entity));
            }
        });
        return true;
    }

    public void deleteAll() {
        this.transactionTemplate.executeWithoutResult(__ -> {
            String query = String.format("DELETE FROM %s s", "JpaRegisteredServiceEntity");
            this.entityManager.createQuery(query).executeUpdate();
        });
    }

    public Collection<RegisteredService> load() {
        return (Collection)this.transactionTemplate.execute(status -> {
            String query = String.format("SELECT r FROM %s r", "JpaRegisteredServiceEntity");
            List list = this.entityManager.createQuery(query, JpaRegisteredServiceEntity.class).getResultList();
            ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
            return list.stream().map(this::toRegisteredService).sorted().map(arg_0 -> ((JpaServiceRegistry)this).invokeServiceRegistryListenerPostLoad(arg_0)).filter(Objects::nonNull).peek(service -> this.publishEvent((ApplicationEvent)new CasRegisteredServiceLoadedEvent((Object)this, service, clientInfo))).collect(Collectors.toList());
        });
    }

    public Long save(Supplier<RegisteredService> supplier, Consumer<RegisteredService> andThenConsume, long countExclusive) {
        return (Long)this.transactionTemplate.execute(__ -> LongStream.range(0L, countExclusive).mapToObj(arg_0 -> JpaServiceRegistry.lambda$save$4((Supplier)supplier, arg_0)).filter(Objects::nonNull).map(this::saveInternal).peek(andThenConsume).filter(Objects::nonNull).count());
    }

    public RegisteredService save(RegisteredService registeredService) {
        return (RegisteredService)this.transactionTemplate.execute(status -> this.saveInternal(registeredService));
    }

    public RegisteredService findServiceById(long id) {
        return (RegisteredService)this.transactionTemplate.execute(__ -> Optional.ofNullable((JpaRegisteredServiceEntity)this.entityManager.find(JpaRegisteredServiceEntity.class, (Object)id)).map(this::toRegisteredService).stream().peek(arg_0 -> ((JpaServiceRegistry)this).invokeServiceRegistryListenerPostLoad(arg_0)).findFirst().orElse(null));
    }

    public RegisteredService findServiceBy(String id) {
        return (RegisteredService)this.transactionTemplate.execute(__ -> {
            String query = String.format("SELECT r FROM %s r WHERE r.serviceId LIKE :serviceId", "JpaRegisteredServiceEntity");
            List results = this.entityManager.createQuery(query, JpaRegisteredServiceEntity.class).setParameter("serviceId", (Object)("%" + id + "%")).getResultList();
            return results.stream().map(this::toRegisteredService).sorted().filter(r -> r.matches(id)).peek(arg_0 -> ((JpaServiceRegistry)this).invokeServiceRegistryListenerPostLoad(arg_0)).findFirst().orElse(null);
        });
    }

    public RegisteredService findServiceByExactServiceId(String id) {
        return (RegisteredService)this.transactionTemplate.execute(__ -> {
            String query = String.format("SELECT r FROM %s r WHERE r.serviceId=:serviceId", "JpaRegisteredServiceEntity");
            List results = this.entityManager.createQuery(query, JpaRegisteredServiceEntity.class).setParameter("serviceId", (Object)id).getResultList();
            return results.stream().map(this::toRegisteredService).sorted().peek(arg_0 -> ((JpaServiceRegistry)this).invokeServiceRegistryListenerPostLoad(arg_0)).findFirst().orElse(null);
        });
    }

    public RegisteredService findServiceByExactServiceName(String name) {
        return (RegisteredService)this.transactionTemplate.execute(__ -> {
            String query = String.format("SELECT r FROM %s r WHERE r.name=:name", "JpaRegisteredServiceEntity");
            List results = this.entityManager.createQuery(query, JpaRegisteredServiceEntity.class).setParameter("name", (Object)name).getResultList();
            return results.stream().map(this::toRegisteredService).sorted().peek(arg_0 -> ((JpaServiceRegistry)this).invokeServiceRegistryListenerPostLoad(arg_0)).findFirst().orElse(null);
        });
    }

    public long size() {
        return (Long)this.transactionTemplate.execute(status -> {
            String query = String.format("SELECT COUNT(r.id) FROM %s r", "JpaRegisteredServiceEntity");
            return (Long)this.entityManager.createQuery(query, Long.class).getSingleResult();
        });
    }

    private RegisteredService saveInternal(RegisteredService registeredService) {
        boolean isNew = registeredService.getId() == -1L;
        this.invokeServiceRegistryListenerPreSave(registeredService);
        JpaRegisteredServiceEntity entity = this.fromRegisteredService(registeredService);
        if (isNew) {
            this.entityManager.persist((Object)entity);
            return this.toRegisteredService(entity);
        }
        JpaRegisteredServiceEntity r = (JpaRegisteredServiceEntity)this.entityManager.merge((Object)entity);
        return this.toRegisteredService(r);
    }

    private JpaRegisteredServiceEntity fromRegisteredService(RegisteredService service) {
        String jsonBody = this.serializer.toString((Object)service);
        return ((JpaRegisteredServiceEntity.JpaRegisteredServiceEntityBuilder)((JpaRegisteredServiceEntity.JpaRegisteredServiceEntityBuilder)((JpaRegisteredServiceEntity.JpaRegisteredServiceEntityBuilder)((JpaRegisteredServiceEntity.JpaRegisteredServiceEntityBuilder)((JpaRegisteredServiceEntity.JpaRegisteredServiceEntityBuilder)JpaRegisteredServiceEntity.builder().id(service.getId())).name(service.getName())).serviceId(service.getServiceId())).evaluationOrder(service.getEvaluationOrder())).body(jsonBody)).build();
    }

    private RegisteredService toRegisteredService(JpaRegisteredServiceEntity entity) {
        RegisteredService service = (RegisteredService)this.serializer.from(entity.getBody());
        service.setId(entity.getId());
        LOGGER.trace("Converted JPA entity [{}] to [{}]", (Object)this, (Object)service);
        return service;
    }

    public void destroy() throws Exception {
        FunctionUtils.doAndHandle(__ -> this.entityManager.close());
    }

    @Generated
    public String toString() {
        return "JpaServiceRegistry(transactionTemplate=" + String.valueOf(this.transactionTemplate) + ", entityManager=" + String.valueOf(this.entityManager) + ", serializer=" + String.valueOf(this.serializer) + ")";
    }

    @Generated
    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    private static /* synthetic */ RegisteredService lambda$save$4(Supplier supplier, long count) {
        return (RegisteredService)supplier.get();
    }
}

