/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.LdapAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.spring.BeanContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.SetFactoryBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Configuration(value="LdapAuthenticationConfiguration", proxyBeanMethods=false)
public class LdapAuthenticationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapAuthenticationConfiguration.class);

    @ConditionalOnMissingBean(name={"ldapPrincipalFactory"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PrincipalFactory ldapPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @Bean
    @ConditionalOnMissingBean(name={"ldapAuthenticationHandlerSetFactoryBean"})
    public SetFactoryBean ldapAuthenticationHandlerSetFactoryBean() {
        return LdapUtils.createLdapAuthenticationFactoryBean();
    }

    @Configuration(value="LdapAuthenticationPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class LdapAuthenticationPlanConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"ldapAuthenticationHandlers"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<AuthenticationHandler> ldapAuthenticationHandlers(@Qualifier(value="ldapAuthenticationHandlerSetFactoryBean") SetFactoryBean ldapAuthenticationHandlerSetFactoryBean, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="ldapPrincipalFactory") PrincipalFactory ldapPrincipalFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager) throws Exception {
            HashSet handlers = new HashSet();
            casProperties.getAuthn().getLdap().stream().filter(l -> {
                if (l.getType() == null || StringUtils.isBlank((CharSequence)l.getLdapUrl())) {
                    LOGGER.warn("Skipping LDAP authentication entry since no type or LDAP url is defined");
                    return false;
                }
                return true;
            }).forEach(l -> {
                LdapAuthenticationHandler handler = LdapUtils.createLdapAuthenticationHandler((LdapAuthenticationProperties)l, (ApplicationContext)applicationContext, (ServicesManager)servicesManager, (PrincipalFactory)ldapPrincipalFactory);
                handler.setState(l.getState());
                handlers.add(handler);
            });
            ((Set)ldapAuthenticationHandlerSetFactoryBean.getObject()).addAll(handlers);
            return BeanContainer.of(handlers);
        }

        @ConditionalOnMissingBean(name={"ldapAuthenticationEventExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationEventExecutionPlanConfigurer ldapAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="ldapAuthenticationHandlers") BeanContainer<AuthenticationHandler> ldapAuthenticationHandlers, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver) throws Exception {
            return plan -> ldapAuthenticationHandlers.toList().forEach(handler -> {
                LOGGER.info("Registering LDAP authentication for [{}]", (Object)handler.getName());
                plan.registerAuthenticationHandlerWithPrincipalResolver(handler, defaultPrincipalResolver);
            });
        }
    }
}

