/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.services;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthTokenExchangePolicy;
import org.apereo.cas.util.RegexUtils;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class DefaultRegisteredServiceOAuthTokenExchangePolicy
implements RegisteredServiceOAuthTokenExchangePolicy {
    private static final long serialVersionUID = 1415436756392637729L;
    private Set<String> allowedResources;
    private Set<String> allowedAudience;
    private Set<String> allowedTokenTypes;

    @Override
    public boolean isTokenExchangeAllowed(RegisteredService registeredService, Set<String> resources, Set<String> audience, String requestedType) {
        boolean resourceAllowed = this.allowedResources == null || this.allowedResources.stream().anyMatch(resource -> RegexUtils.find((String)resource, (String)requestedType));
        boolean audienceAllowed = this.allowedAudience == null || this.allowedAudience.stream().anyMatch(aud -> RegexUtils.find((String)aud, (String)requestedType));
        boolean tokenTypeAllowed = this.allowedTokenTypes == null || this.allowedTokenTypes.stream().anyMatch(type -> RegexUtils.find((String)type, (String)requestedType));
        return resourceAllowed && audienceAllowed && tokenTypeAllowed;
    }

    @Generated
    public Set<String> getAllowedResources() {
        return this.allowedResources;
    }

    @Generated
    public Set<String> getAllowedAudience() {
        return this.allowedAudience;
    }

    @Generated
    public Set<String> getAllowedTokenTypes() {
        return this.allowedTokenTypes;
    }

    @Generated
    public DefaultRegisteredServiceOAuthTokenExchangePolicy setAllowedResources(Set<String> allowedResources) {
        this.allowedResources = allowedResources;
        return this;
    }

    @Generated
    public DefaultRegisteredServiceOAuthTokenExchangePolicy setAllowedAudience(Set<String> allowedAudience) {
        this.allowedAudience = allowedAudience;
        return this;
    }

    @Generated
    public DefaultRegisteredServiceOAuthTokenExchangePolicy setAllowedTokenTypes(Set<String> allowedTokenTypes) {
        this.allowedTokenTypes = allowedTokenTypes;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultRegisteredServiceOAuthTokenExchangePolicy)) {
            return false;
        }
        DefaultRegisteredServiceOAuthTokenExchangePolicy other = (DefaultRegisteredServiceOAuthTokenExchangePolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$allowedResources = this.allowedResources;
        Set<String> other$allowedResources = other.allowedResources;
        if (this$allowedResources == null ? other$allowedResources != null : !((Object)this$allowedResources).equals(other$allowedResources)) {
            return false;
        }
        Set<String> this$allowedAudience = this.allowedAudience;
        Set<String> other$allowedAudience = other.allowedAudience;
        if (this$allowedAudience == null ? other$allowedAudience != null : !((Object)this$allowedAudience).equals(other$allowedAudience)) {
            return false;
        }
        Set<String> this$allowedTokenTypes = this.allowedTokenTypes;
        Set<String> other$allowedTokenTypes = other.allowedTokenTypes;
        return !(this$allowedTokenTypes == null ? other$allowedTokenTypes != null : !((Object)this$allowedTokenTypes).equals(other$allowedTokenTypes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultRegisteredServiceOAuthTokenExchangePolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $allowedResources = this.allowedResources;
        result = result * 59 + ($allowedResources == null ? 43 : ((Object)$allowedResources).hashCode());
        Set<String> $allowedAudience = this.allowedAudience;
        result = result * 59 + ($allowedAudience == null ? 43 : ((Object)$allowedAudience).hashCode());
        Set<String> $allowedTokenTypes = this.allowedTokenTypes;
        result = result * 59 + ($allowedTokenTypes == null ? 43 : ((Object)$allowedTokenTypes).hashCode());
        return result;
    }

    @Generated
    public DefaultRegisteredServiceOAuthTokenExchangePolicy(Set<String> allowedResources, Set<String> allowedAudience, Set<String> allowedTokenTypes) {
        this.allowedResources = allowedResources;
        this.allowedAudience = allowedAudience;
        this.allowedTokenTypes = allowedTokenTypes;
    }

    @Generated
    public DefaultRegisteredServiceOAuthTokenExchangePolicy() {
    }

    @Generated
    public String toString() {
        return "DefaultRegisteredServiceOAuthTokenExchangePolicy(allowedResources=" + String.valueOf(this.allowedResources) + ", allowedAudience=" + String.valueOf(this.allowedAudience) + ", allowedTokenTypes=" + String.valueOf(this.allowedTokenTypes) + ")";
    }
}

