/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategyConfigurer;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuth20AuthenticationServiceSelectionStrategy;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@Configuration(value="CasOAuth20AuthenticationServiceSelectionStrategyConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasOAuth20AuthenticationServiceSelectionStrategyConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"oauth20AuthenticationRequestServiceSelectionStrategy"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuthenticationServiceSelectionStrategy oauth20AuthenticationRequestServiceSelectionStrategy(@Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties) {
        return new OAuth20AuthenticationServiceSelectionStrategy(servicesManager, webApplicationServiceFactory, OAuth20Utils.casOAuthCallbackUrl((String)casProperties.getServer().getPrefix()));
    }

    @Bean
    public AuthenticationServiceSelectionStrategyConfigurer oauth20AuthenticationServiceSelectionStrategyConfigurer(@Qualifier(value="oauth20AuthenticationRequestServiceSelectionStrategy") AuthenticationServiceSelectionStrategy oauth20AuthenticationRequestServiceSelectionStrategy) {
        return plan -> plan.registerStrategy(oauth20AuthenticationRequestServiceSelectionStrategy);
    }
}

