/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationCookieProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationWebflowManager;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.cas.client.CasClient;
import org.pac4j.core.client.Client;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.oauth.client.OAuth10Client;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.saml.client.SAML2Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.webflow.execution.RequestContext;

@Transactional(transactionManager="ticketTransactionManager")
public class DefaultDelegatedClientAuthenticationWebflowManager
implements DelegatedClientAuthenticationWebflowManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDelegatedClientAuthenticationWebflowManager.class);
    private static final String OIDC_CLIENT_ID_SESSION_KEY = "OIDC_CLIENT_ID";
    private static final String OAUTH20_CLIENT_ID_SESSION_KEY = "OAUTH20_CLIENT_ID";
    private static final String OAUTH10_CLIENT_ID_SESSION_KEY = "OAUTH10_CLIENT_ID";
    private static final String CAS_CLIENT_ID_SESSION_KEY = "CAS_CLIENT_ID";
    private final DelegatedClientAuthenticationConfigurationContext configContext;

    @Override
    public TransientSessionTicket store(JEEContext webContext, Client client) throws Exception {
        TransientSessionTicket ticket = this.storeDelegatedClientAuthenticationRequest(webContext);
        this.rememberSelectedClientIfNecessary(webContext, client);
        if (client instanceof SAML2Client) {
            this.trackSessionIdForSAML2Client((WebContext)webContext, ticket, (SAML2Client)client);
        }
        if (client instanceof OAuth20Client) {
            this.trackSessionIdForOAuth20Client((WebContext)webContext, (OAuth20Client)client, ticket);
        }
        if (client instanceof OidcClient) {
            this.trackSessionIdForOidcClient((WebContext)webContext, (OidcClient)client, ticket);
        }
        if (client instanceof CasClient) {
            this.trackSessionIdForCasClient((WebContext)webContext, ticket, (CasClient)client);
        }
        if (client instanceof OAuth10Client) {
            this.trackSessionIdForOAuth10Client((WebContext)webContext, ticket);
        }
        return ticket;
    }

    @Override
    public Service retrieve(RequestContext requestContext, WebContext webContext, Client client) throws Exception {
        String clientId = this.getDelegatedClientId(webContext, client);
        TransientSessionTicket ticket = this.retrieveSessionTicketViaClientId(webContext, clientId);
        this.restoreDelegatedAuthenticationRequest(requestContext, webContext, ticket);
        LOGGER.debug("Removing delegated client identifier [{}] from registry", (Object)ticket.getId());
        this.configContext.getCentralAuthenticationService().deleteTicket(ticket.getId());
        return ticket.getService();
    }

    protected void trackSessionIdForOAuth10Client(WebContext webContext, TransientSessionTicket ticket) {
        this.configContext.getSessionStore().set(webContext, OAUTH10_CLIENT_ID_SESSION_KEY, (Object)ticket.getId());
    }

    protected void trackSessionIdForCasClient(WebContext webContext, TransientSessionTicket ticket, CasClient casClient) {
        this.configContext.getSessionStore().set(webContext, CAS_CLIENT_ID_SESSION_KEY, (Object)ticket.getId());
    }

    protected void trackSessionIdForOidcClient(WebContext webContext, OidcClient client, TransientSessionTicket ticket) {
        this.configContext.getSessionStore().set(webContext, OIDC_CLIENT_ID_SESSION_KEY, (Object)ticket.getId());
    }

    protected void trackSessionIdForOAuth20Client(WebContext webContext, OAuth20Client client, TransientSessionTicket ticket) {
        this.configContext.getSessionStore().set(webContext, OAUTH20_CLIENT_ID_SESSION_KEY, (Object)ticket.getId());
    }

    protected void trackSessionIdForSAML2Client(WebContext webContext, TransientSessionTicket ticket, SAML2Client saml2Client) {
        this.configContext.getSessionStore().set(webContext, "samlRelayState", (Object)ticket.getId());
    }

    protected TransientSessionTicket storeDelegatedClientAuthenticationRequest(JEEContext webContext) throws Exception {
        Map<String, Serializable> properties = this.buildTicketProperties((WebContext)webContext);
        WebApplicationService originalService = this.configContext.getArgumentExtractor().extractService(webContext.getNativeRequest());
        Service service = this.configContext.getAuthenticationRequestServiceSelectionStrategies().resolveService((Service)originalService);
        properties.put("service", (Serializable)originalService);
        properties.put("targetService", (Serializable)service);
        RegisteredService registeredService = this.configContext.getServicesManager().findServiceBy(service);
        webContext.getRequestParameter("ForceAuthn").or(() -> Optional.of(Boolean.toString(RegisteredServiceProperty.RegisteredServiceProperties.DELEGATED_AUTHN_FORCE_AUTHN.isAssignedTo(registeredService)))).filter(value -> StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)"true")).ifPresent(attr -> properties.put("ForceAuthn", (Serializable)true));
        webContext.getRequestParameter("Passive").or(() -> Optional.of(Boolean.toString(RegisteredServiceProperty.RegisteredServiceProperties.DELEGATED_AUTHN_PASSIVE_AUTHN.isAssignedTo(registeredService)))).filter(value -> StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)"true")).ifPresent(attr -> properties.put("Passive", (Serializable)true));
        TransientSessionTicketFactory transientFactory = (TransientSessionTicketFactory)this.configContext.getTicketFactory().get(TransientSessionTicket.class);
        TransientSessionTicket ticket = transientFactory.create((Service)originalService, properties);
        LOGGER.debug("Storing delegated authentication request ticket [{}] for service [{}] with properties [{}]", new Object[]{ticket.getId(), ticket.getService(), ticket.getProperties()});
        this.configContext.getCentralAuthenticationService().addTicket((Ticket)ticket);
        webContext.setRequestAttribute("delegatedclientid", (Object)ticket.getId());
        if (properties.containsKey("ForceAuthn")) {
            webContext.setRequestAttribute("ForceAuthn", (Object)true);
        }
        if (properties.containsKey("Passive")) {
            webContext.setRequestAttribute("Passive", (Object)true);
        }
        return ticket;
    }

    protected void rememberSelectedClientIfNecessary(JEEContext webContext, Client client) {
        Pac4jDelegatedAuthenticationCookieProperties cookieProps = this.configContext.getCasProperties().getAuthn().getPac4j().getCookie();
        if (cookieProps.isEnabled()) {
            if (cookieProps.isAutoConfigureCookiePath()) {
                String contextPath = webContext.getNativeRequest().getContextPath();
                Object cookiePath = StringUtils.isNotBlank((CharSequence)contextPath) ? contextPath + "/" : "/";
                String path = this.configContext.getDelegatedClientCookieGenerator().getCookiePath();
                if (StringUtils.isBlank((CharSequence)path)) {
                    LOGGER.debug("Setting path for cookies for delegated authentication cookie generator to: [{}]", cookiePath);
                    this.configContext.getDelegatedClientCookieGenerator().setCookiePath((String)cookiePath);
                }
            }
            this.configContext.getDelegatedClientCookieGenerator().addCookie(webContext.getNativeRequest(), webContext.getNativeResponse(), client.getName());
        }
    }

    protected Map<String, Serializable> buildTicketProperties(WebContext webContext) {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        String themeParamName = this.configContext.getCasProperties().getTheme().getParamName();
        String localParamName = this.configContext.getCasProperties().getLocale().getParamName();
        properties.put(themeParamName, webContext.getRequestParameter(themeParamName).map(String::valueOf).orElse(null));
        properties.put(localParamName, webContext.getRequestParameter(localParamName).map(String::valueOf).orElse(null));
        properties.put("method", webContext.getRequestParameter("method").map(String::valueOf).orElse(null));
        LOGGER.debug("Built ticket properties [{}]", properties);
        return properties;
    }

    protected Service restoreDelegatedAuthenticationRequest(RequestContext requestContext, WebContext webContext, TransientSessionTicket ticket) {
        Service service = ticket.getService();
        LOGGER.trace("Restoring requested service [{}] back in the authentication flow", (Object)service);
        WebUtils.putServiceIntoFlowScope((RequestContext)requestContext, (Service)service);
        webContext.setRequestAttribute("service", (Object)service);
        String themeParamName = this.configContext.getCasProperties().getTheme().getParamName();
        String localParamName = this.configContext.getCasProperties().getLocale().getParamName();
        Map properties = ticket.getProperties();
        webContext.setRequestAttribute(themeParamName, properties.get(themeParamName));
        Object localeValue = properties.get(localParamName);
        Optional.ofNullable(localeValue).ifPresent(locale -> {
            webContext.setRequestAttribute(localParamName, locale);
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
            HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
            Optional.ofNullable(RequestContextUtils.getLocaleResolver((HttpServletRequest)request)).ifPresent(localeResolver -> localeResolver.setLocale(request, response, new Locale(locale.toString())));
        });
        webContext.setRequestAttribute("method", properties.get("method"));
        return service;
    }

    protected TransientSessionTicket retrieveSessionTicketViaClientId(WebContext webContext, String clientId) {
        try {
            TransientSessionTicket ticket = (TransientSessionTicket)this.configContext.getCentralAuthenticationService().getTicket(clientId, TransientSessionTicket.class);
            LOGGER.debug("Located delegated authentication client identifier as [{}]", (Object)ticket.getId());
            return ticket;
        }
        catch (Exception e) {
            LOGGER.error("Delegated client identifier cannot be located in the authentication request [{}]", (Object)webContext.getFullRequestURL());
            throw new UnauthorizedServiceException("screen.service.error.message", "");
        }
    }

    protected String getDelegatedClientId(WebContext webContext, Client client) {
        String clientId = webContext.getRequestParameter("delegatedclientid").map(String::valueOf).orElse("");
        if (StringUtils.isBlank((CharSequence)clientId) && client instanceof SAML2Client) {
            LOGGER.debug("Client identifier could not found in request parameters. Looking at relay-state for the SAML2 client");
            clientId = webContext.getRequestParameter("RelayState").map(String::valueOf).orElse("");
        }
        clientId = this.getDelegatedClientIdFromSessionStore(webContext, client, clientId, OAuth20Client.class, OAUTH20_CLIENT_ID_SESSION_KEY);
        clientId = this.getDelegatedClientIdFromSessionStore(webContext, client, clientId, OidcClient.class, OIDC_CLIENT_ID_SESSION_KEY);
        clientId = this.getDelegatedClientIdFromSessionStore(webContext, client, clientId, OAuth10Client.class, OAUTH10_CLIENT_ID_SESSION_KEY);
        clientId = this.getDelegatedClientIdFromSessionStore(webContext, client, clientId, CasClient.class, CAS_CLIENT_ID_SESSION_KEY);
        LOGGER.debug("Located delegated client identifier [{}]", (Object)clientId);
        return clientId;
    }

    protected String getDelegatedClientIdFromSessionStore(WebContext webContext, Client client, String clientId, Class clientClass, String key) {
        if (StringUtils.isBlank((CharSequence)clientId) && client != null && clientClass.isAssignableFrom(client.getClass())) {
            LOGGER.debug("Client identifier could not be found in request parameters. Looking at session store for the [{}] client", (Object)clientClass);
            String newClientId = this.configContext.getSessionStore().get(webContext, key).map(Object::toString).orElse("");
            this.configContext.getSessionStore().set(webContext, key, null);
            return newClientId;
        }
        return clientId;
    }

    @Generated
    public DefaultDelegatedClientAuthenticationWebflowManager(DelegatedClientAuthenticationConfigurationContext configContext) {
        this.configContext = configContext;
    }

    @Generated
    public DelegatedClientAuthenticationConfigurationContext getConfigContext() {
        return this.configContext;
    }
}

