/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.DefaultErrorViewResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.ModelAndView;

public class DelegatedAuthenticationErrorViewResolver
extends DefaultErrorViewResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedAuthenticationErrorViewResolver.class);

    public DelegatedAuthenticationErrorViewResolver(ApplicationContext applicationContext, WebProperties.Resources resources) {
        super(applicationContext, resources);
    }

    public ModelAndView resolveErrorView(HttpServletRequest request, HttpStatus status, Map<String, Object> map) {
        Throwable cause;
        Optional<ModelAndView> mv = DelegatedClientAuthenticationAction.hasDelegationRequestFailed(request, status.value());
        Object exception = request.getAttribute("javax.servlet.error.exception");
        if (exception != null && (cause = ((Throwable)exception).getCause()) instanceof UnauthorizedServiceException) {
            ModelAndView mvError = new ModelAndView("delegated-authn/casDelegatedAuthnErrorView", HttpStatus.FORBIDDEN);
            LOGGER.warn("Delegated authentication failed with the following details [{}]; Routing over to [{}]", map, (Object)mvError.getViewName());
            return mvError;
        }
        return mv.orElseGet(() -> super.resolveErrorView(request, status, map));
    }
}

