/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.adaptive.UnauthorizedAuthenticationException;
import org.apereo.cas.authentication.principal.ClientCredential;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.delegation.DelegationAutoRedirectTypes;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationWebflowManager;
import org.apereo.cas.web.flow.SingleSignOnParticipationRequest;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.actions.AbstractAuthenticationAction;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Client;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.http.adapter.JEEHttpActionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedClientAuthenticationAction
extends AbstractAuthenticationAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedClientAuthenticationAction.class);
    protected final DelegatedClientAuthenticationConfigurationContext configContext;
    private final DelegatedClientAuthenticationWebflowManager delegatedClientAuthenticationWebflowManager;

    public DelegatedClientAuthenticationAction(DelegatedClientAuthenticationConfigurationContext context, DelegatedClientAuthenticationWebflowManager delegatedClientAuthenticationWebflowManager) {
        super(context.getInitialAuthenticationAttemptWebflowEventResolver(), context.getServiceTicketRequestWebflowEventResolver(), context.getAdaptiveAuthenticationPolicy());
        this.configContext = context;
        this.delegatedClientAuthenticationWebflowManager = delegatedClientAuthenticationWebflowManager;
    }

    public static Optional<ModelAndView> hasDelegationRequestFailed(HttpServletRequest request, int status) {
        Map params = request.getParameterMap();
        if (Stream.of("error", "error_code", "error_description", "error_message").anyMatch(params::containsKey)) {
            HashMap<String, Object> model = new HashMap<String, Object>();
            if (params.containsKey("error_code")) {
                model.put("code", StringEscapeUtils.escapeHtml4((String)request.getParameter("error_code")));
            } else {
                model.put("code", status);
            }
            model.put("error", StringEscapeUtils.escapeHtml4((String)request.getParameter("error")));
            model.put("reason", StringEscapeUtils.escapeHtml4((String)request.getParameter("error_reason")));
            if (params.containsKey("error_description")) {
                model.put("description", StringEscapeUtils.escapeHtml4((String)request.getParameter("error_description")));
            } else if (params.containsKey("error_message")) {
                model.put("description", StringEscapeUtils.escapeHtml4((String)request.getParameter("error_message")));
            }
            model.put("service", request.getAttribute("service"));
            model.put("client", StringEscapeUtils.escapeHtml4((String)request.getParameter("client_name")));
            LOGGER.debug("Delegation request has failed. Details are [{}]", model);
            return Optional.of(new ModelAndView("delegated-authn/casDelegatedAuthnStopWebflow", model));
        }
        return Optional.empty();
    }

    protected static boolean isLogoutRequest(HttpServletRequest request) {
        return request.getParameter("logoutendpoint") != null;
    }

    public Event doExecute(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
        JEEContext webContext = new JEEContext(request, response);
        try {
            String clientName = this.retrieveClientName((WebContext)webContext);
            LOGGER.trace("Delegated authentication is handled by client name [{}]", (Object)clientName);
            Service service = null;
            if (!DelegatedClientAuthenticationAction.isLogoutRequest(request) && this.singleSignOnSessionExists(context) && StringUtils.isNotBlank((CharSequence)clientName)) {
                LOGGER.trace("Found existing single sign-on session");
                service = this.populateContextWithService(context, webContext, clientName);
                if (this.singleSignOnSessionAuthorizedForService(context)) {
                    Set providers = this.configContext.getDelegatedClientIdentityProvidersProducer().produce(context);
                    LOGGER.debug("Skipping delegation and routing back to CAS authentication flow with providers [{}]", (Object)providers);
                    return super.doExecute(context);
                }
                Service resolvedService = this.resolveServiceFromRequestContext(context);
                LOGGER.debug("Single sign-on session in unauthorized for service [{}]", (Object)resolvedService);
                String tgt = WebUtils.getTicketGrantingTicketId((RequestContext)context);
                this.configContext.getCentralAuthenticationService().deleteTicket(tgt);
            }
            if (DelegatedClientAuthenticationAction.hasDelegationRequestFailed(request, response.getStatus()).isPresent()) {
                throw new IllegalArgumentException("Delegated authentication has failed with client " + clientName);
            }
            if (StringUtils.isNotBlank((CharSequence)clientName)) {
                if (service == null) {
                    service = this.populateContextWithService(context, webContext, clientName);
                }
                BaseClient client = this.findDelegatedClientByName(request, clientName, service);
                WebUtils.putDelegatedAuthenticationClientName((RequestContext)context, (String)client.getName());
                this.populateContextWithClientCredential(client, webContext, context);
                return super.doExecute(context);
            }
            this.produceDelegatedAuthenticationClientsForContext(context);
        }
        catch (HttpAction e) {
            FunctionUtils.doIf((boolean)LOGGER.isDebugEnabled(), o -> LOGGER.debug(e.getMessage(), (Throwable)e), o -> LOGGER.info(e.getMessage())).accept(e);
            JEEHttpActionAdapter.INSTANCE.adapt(e, (WebContext)webContext);
            return DelegatedClientAuthenticationAction.isLogoutRequest(request) ? this.error() : this.success();
        }
        catch (UnauthorizedServiceException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return this.stopWebflow(e, context);
        }
        return this.error();
    }

    protected String retrieveClientName(WebContext webContext) {
        return webContext.getRequestParameter("client_name").orElse(null);
    }

    protected void produceDelegatedAuthenticationClientsForContext(RequestContext context) {
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
        Set providers = this.configContext.getDelegatedClientIdentityProvidersProducer().produce(context);
        LOGGER.trace("Delegated authentication providers are finalized as [{}]", (Object)providers);
        WebUtils.createCredential((RequestContext)context);
        if (response.getStatus() == HttpStatus.UNAUTHORIZED.value()) {
            throw new UnauthorizedAuthenticationException("Authentication is not authorized: " + response.getStatus());
        }
        this.configContext.getDelegatedClientIdentityProviderConfigurationPostProcessor().process(context, providers);
        if (!this.singleSignOnSessionExists(context)) {
            providers.stream().filter(provider -> provider.getAutoRedirectType() == DelegationAutoRedirectTypes.SERVER).findFirst().ifPresent(Unchecked.consumer(provider -> {
                LOGGER.debug("Redirecting to [{}]", (Object)provider.getRedirectUrl());
                response.sendRedirect(provider.getRedirectUrl());
            }));
        }
    }

    protected Event doPreExecute(RequestContext context) throws Exception {
        CasConfigurationProperties casProperties = this.configContext.getCasProperties();
        if (casProperties.getAuthn().getPac4j().getCore().isReplicateSessions() && casProperties.getSessionReplication().getCookie().isAutoConfigureCookiePath()) {
            String contextPath = context.getExternalContext().getContextPath();
            Object cookiePath = StringUtils.isNotBlank((CharSequence)contextPath) ? contextPath + "/" : "/";
            String path = this.configContext.getDelegatedClientDistributedSessionCookieGenerator().getCookiePath();
            if (StringUtils.isBlank((CharSequence)path)) {
                LOGGER.debug("Setting path for cookies for distributed session cookie generator to: [{}]", cookiePath);
                this.configContext.getDelegatedClientDistributedSessionCookieGenerator().setCookiePath((String)cookiePath);
            } else {
                LOGGER.trace("Delegated authentication cookie domain is [{}] with path [{}]", (Object)this.configContext.getDelegatedClientDistributedSessionCookieGenerator().getCookieDomain(), (Object)path);
            }
        }
        return super.doPreExecute(context);
    }

    protected Service populateContextWithService(RequestContext context, JEEContext webContext, String clientName) {
        Service service = this.restoreAuthenticationRequestInContext(context, webContext, clientName);
        Service resolvedService = this.configContext.getAuthenticationRequestServiceSelectionStrategies().resolveService(service);
        LOGGER.trace("Authentication is resolved by service request from [{}]", (Object)service);
        RegisteredService registeredService = this.configContext.getServicesManager().findServiceBy(resolvedService);
        LOGGER.trace("Located registered service [{}] mapped to resolved service [{}]", (Object)registeredService, (Object)resolvedService);
        WebUtils.putRegisteredService((RequestContext)context, (RegisteredService)registeredService);
        WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)service);
        return service;
    }

    protected void populateContextWithClientCredential(BaseClient client, JEEContext webContext, RequestContext requestContext) {
        LOGGER.debug("Fetching credentials from delegated client [{}]", (Object)client);
        Credentials credentials = this.getCredentialsFromDelegatedClient(webContext, client);
        ClientCredential clientCredential = new ClientCredential(credentials, client.getName());
        LOGGER.info("Credentials are successfully authenticated using the delegated client [{}]", (Object)client.getName());
        WebUtils.putCredential((RequestContext)requestContext, (Credential)clientCredential);
    }

    protected Credentials getCredentialsFromDelegatedClient(JEEContext webContext, BaseClient client) {
        Optional credentials = client.getCredentials((WebContext)webContext, this.configContext.getSessionStore());
        LOGGER.debug("Retrieved credentials from client as [{}]", (Object)credentials);
        if (credentials.isEmpty()) {
            throw new IllegalArgumentException("Unable to determine credentials from the context with client " + client.getName());
        }
        return (Credentials)credentials.get();
    }

    protected BaseClient findDelegatedClientByName(HttpServletRequest request, String clientName, Service service) {
        Optional clientResult = this.configContext.getClients().findClient(clientName);
        if (clientResult.isEmpty()) {
            LOGGER.warn("Delegated client [{}] can not be located", (Object)clientName);
            throw new UnauthorizedServiceException("screen.service.error.message", "");
        }
        BaseClient client = (BaseClient)BaseClient.class.cast(clientResult.get());
        LOGGER.debug("Delegated authentication client is [{}] with service [{}]", (Object)client, (Object)service);
        if (service != null) {
            request.setAttribute("service", (Object)service.getId());
            if (!this.isDelegatedClientAuthorizedForService((Client)client, service, request)) {
                LOGGER.warn("Delegated client [{}] is not authorized by service [{}]", (Object)client, (Object)service);
                throw new UnauthorizedServiceException("screen.service.error.message", "");
            }
        }
        client.init();
        return client;
    }

    protected Event stopWebflow(Exception e, RequestContext requestContext) {
        requestContext.getFlashScope().put("rootCauseException", (Object)e);
        return new Event((Object)this, "stop", (AttributeMap)new LocalAttributeMap("error", (Object)e));
    }

    protected Service restoreAuthenticationRequestInContext(RequestContext requestContext, JEEContext webContext, String clientName) {
        boolean logoutEndpoint = DelegatedClientAuthenticationAction.isLogoutRequest(webContext.getNativeRequest());
        if (logoutEndpoint) {
            return null;
        }
        try {
            Optional clientResult = this.configContext.getClients().findClient(clientName);
            if (clientResult.isPresent()) {
                return this.delegatedClientAuthenticationWebflowManager.retrieve(requestContext, (WebContext)webContext, (Client)BaseClient.class.cast(clientResult.get()));
            }
            LOGGER.warn("Unable to locate client [{}] in registered clients", (Object)clientName);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        throw new UnauthorizedServiceException("screen.service.error.message", "");
    }

    protected boolean singleSignOnSessionAuthorizedForService(RequestContext requestContext) {
        Service resolvedService = this.resolveServiceFromRequestContext(requestContext);
        Optional<Authentication> authentication = this.getSingleSignOnAuthenticationFrom(requestContext);
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        Boolean authorized = authentication.map(authn -> this.configContext.getDelegatedAuthenticationAccessStrategyHelper().isDelegatedClientAuthorizedForAuthentication(authn, resolvedService, request)).orElse(Boolean.FALSE);
        SingleSignOnParticipationStrategy strategy = this.configContext.getSingleSignOnParticipationStrategy();
        SingleSignOnParticipationRequest ssoRequest = SingleSignOnParticipationRequest.builder().requestContext(requestContext).build();
        return authorized != false && strategy.supports(ssoRequest) && strategy.isParticipating(ssoRequest);
    }

    protected boolean singleSignOnSessionExists(RequestContext requestContext) {
        try {
            Optional<Authentication> authn = this.getSingleSignOnAuthenticationFrom(requestContext);
            if (authn.isPresent()) {
                LOGGER.trace("Located a valid ticket-granting ticket. Examining existing single sign-on session strategies...");
                Authentication authentication = authn.get();
                AuthenticationResultBuilder builder = this.configContext.getAuthenticationSystemSupport().establishAuthenticationContextFromInitial(authentication);
                LOGGER.trace("Recording and tracking initial authentication results in the request context");
                WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)builder, (RequestContext)requestContext);
                WebUtils.putAuthentication((Authentication)authentication, (RequestContext)requestContext);
                SingleSignOnParticipationStrategy strategy = this.configContext.getSingleSignOnParticipationStrategy();
                SingleSignOnParticipationRequest ssoRequest = SingleSignOnParticipationRequest.builder().requestContext(requestContext).build();
                return strategy.supports(ssoRequest) && strategy.isParticipating(ssoRequest);
            }
        }
        catch (AbstractTicketException e) {
            LOGGER.trace("Could not retrieve ticket id [{}] from registry.", (Object)e.getMessage());
        }
        LOGGER.trace("Ticket-granting ticket found in the webflow context is invalid or has expired");
        return false;
    }

    private Service resolveServiceFromRequestContext(RequestContext context) {
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        return this.configContext.getAuthenticationRequestServiceSelectionStrategies().resolveService((Service)service);
    }

    private Optional<Authentication> getSingleSignOnAuthenticationFrom(RequestContext requestContext) {
        String tgtId = WebUtils.getTicketGrantingTicketId((RequestContext)requestContext);
        if (StringUtils.isBlank((CharSequence)tgtId)) {
            LOGGER.trace("No ticket-granting ticket could be located in the webflow context");
            return Optional.empty();
        }
        TicketGrantingTicket ticket = (TicketGrantingTicket)this.configContext.getCentralAuthenticationService().getTicket(tgtId, TicketGrantingTicket.class);
        LOGGER.trace("Located a valid ticket-granting ticket");
        return Optional.of(ticket.getAuthentication());
    }

    private boolean isDelegatedClientAuthorizedForService(Client client, Service service, HttpServletRequest request) {
        return this.configContext.getDelegatedAuthenticationAccessStrategyHelper().isDelegatedClientAuthorizedForService(client, service, request);
    }

    @Generated
    public DelegatedClientAuthenticationConfigurationContext getConfigContext() {
        return this.configContext;
    }

    @Generated
    public DelegatedClientAuthenticationWebflowManager getDelegatedClientAuthenticationWebflowManager() {
        return this.delegatedClientAuthenticationWebflowManager;
    }
}

