/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.scribejava.core.model.OAuth1RequestToken;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.validation.DelegatedAuthenticationServiceTicketValidationAuthorizer;
import org.apereo.cas.validation.RegisteredServiceDelegatedAuthenticationPolicyAuditableEnforcer;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizer;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizerConfigurer;
import org.apereo.cas.web.flow.DelegatedAuthenticationSingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategyConfigurer;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@Configuration(value="Pac4jDelegatedAuthenticationConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class Pac4jDelegatedAuthenticationConfiguration {

    private static abstract class AbstractOAuth1RequestTokenMixin
    extends OAuth1RequestToken {
        private static final long serialVersionUID = -7839084408338396531L;

        @JsonCreator
        AbstractOAuth1RequestTokenMixin(@JsonProperty(value="token") String token, @JsonProperty(value="tokenSecret") String tokenSecret, @JsonProperty(value="oauthCallbackConfirmed") boolean oauthCallbackConfirmed, @JsonProperty(value="rawResponse") String rawResponse) {
            super(token, tokenSecret, oauthCallbackConfirmed, rawResponse);
        }

        @JsonIgnore
        public abstract boolean isEmpty();
    }

    @Configuration(value="Pac4jDelegatedAuthenticationSingleSignOnConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class Pac4jDelegatedAuthenticationSingleSignOnConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"pac4jDelegatedAuthenticationSingleSignOnParticipationStrategy"})
        public SingleSignOnParticipationStrategy pac4jDelegatedAuthenticationSingleSignOnParticipationStrategy(@Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new DelegatedAuthenticationSingleSignOnParticipationStrategy(servicesManager, authenticationServiceSelectionPlan, ticketRegistrySupport);
        }

        @Bean
        @ConditionalOnMissingBean(name={"pac4jDelegatedAuthenticationSingleSignOnParticipationStrategyConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleSignOnParticipationStrategyConfigurer pac4jDelegatedAuthenticationSingleSignOnParticipationStrategyConfigurer(@Qualifier(value="pac4jDelegatedAuthenticationSingleSignOnParticipationStrategy") SingleSignOnParticipationStrategy pac4jDelegatedAuthenticationSingleSignOnParticipationStrategy) {
            return chain -> chain.addStrategy(pac4jDelegatedAuthenticationSingleSignOnParticipationStrategy);
        }
    }

    @Configuration(value="Pac4jDelegatedAuthenticationAuthorizerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class Pac4jDelegatedAuthenticationAuthorizerConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceTicketValidationAuthorizer pac4jServiceTicketValidationAuthorizer(@Qualifier(value="registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer") AuditableExecution registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new DelegatedAuthenticationServiceTicketValidationAuthorizer(servicesManager, registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceTicketValidationAuthorizerConfigurer pac4jServiceTicketValidationAuthorizerConfigurer(@Qualifier(value="pac4jServiceTicketValidationAuthorizer") ServiceTicketValidationAuthorizer pac4jServiceTicketValidationAuthorizer) {
            return plan -> plan.registerAuthorizer(pac4jServiceTicketValidationAuthorizer);
        }
    }

    @Configuration(value="Pac4jDelegatedAuthenticationBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class Pac4jDelegatedAuthenticationBaseConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer"})
        public AuditableExecution registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer() {
            return new RegisteredServiceDelegatedAuthenticationPolicyAuditableEnforcer();
        }

        @Bean
        @ConditionalOnMissingBean(name={"pac4jJacksonModule"})
        public Module pac4jJacksonModule() {
            SimpleModule module = new SimpleModule();
            module.setMixInAnnotation(OAuth1RequestToken.class, AbstractOAuth1RequestTokenMixin.class);
            return module;
        }
    }
}

