/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.AttributeRepositoryStates;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.BeanContainer;
import org.apereo.cas.util.spring.boot.ConditionalOnMultiValuedProperty;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.support.IUsernameAttributeProvider;
import org.apereo.services.persondir.support.RestfulPersonAttributeDao;
import org.apereo.services.persondir.support.SimpleUsernameAttributeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.http.HttpMethod;

@ConditionalOnMultiValuedProperty(name="cas.authn.attribute-repository.rest[0]", value={"url"})
@Configuration(value="CasPersonDirectoryRestConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasPersonDirectoryRestConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasPersonDirectoryRestConfiguration.class);

    @Configuration(value="RestfulAttributeRepositoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class RestfulAttributeRepositoryPlanConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"restfulPersonDirectoryAttributeRepositoryPlanConfigurer"})
        public PersonDirectoryAttributeRepositoryPlanConfigurer restfulPersonDirectoryAttributeRepositoryPlanConfigurer(@Qualifier(value="restfulAttributeRepositories") BeanContainer<IPersonAttributeDao> restfulAttributeRepositories) {
            return plan -> {
                List results = restfulAttributeRepositories.toList().stream().filter(repo -> (Boolean)repo.getTags().get(PersonDirectoryAttributeRepositoryPlanConfigurer.class.getSimpleName())).collect(Collectors.toList());
                plan.registerAttributeRepositories(results);
            };
        }
    }

    @Configuration(value="RestfulAttributeRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class RestfulAttributeRepositoryConfiguration {
        @ConditionalOnMissingBean(name={"restfulAttributeRepositories"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<IPersonAttributeDao> restfulAttributeRepositories(CasConfigurationProperties casProperties) {
            ArrayList list = new ArrayList();
            casProperties.getAuthn().getAttributeRepository().getRest().stream().filter(rest -> StringUtils.isNotBlank((CharSequence)rest.getUrl())).forEach(rest -> {
                RestfulPersonAttributeDao dao = new RestfulPersonAttributeDao();
                dao.setCaseInsensitiveUsername(rest.isCaseInsensitive());
                dao.setOrder(rest.getOrder());
                FunctionUtils.doIfNotNull((Object)rest.getId(), xva$0 -> dao.setId(new String[]{xva$0}));
                dao.setUrl(rest.getUrl());
                dao.setMethod(Objects.requireNonNull(HttpMethod.resolve((String)rest.getMethod())).name());
                dao.setEnabled(rest.getState() != AttributeRepositoryStates.DISABLED);
                Map headers = CollectionUtils.wrap((String)"Content-Type", (Object)"application/json");
                headers.putAll(rest.getHeaders());
                dao.setHeaders(headers);
                dao.setUsernameAttributeProvider((IUsernameAttributeProvider)new SimpleUsernameAttributeProvider(rest.getUsernameAttribute()));
                dao.putTag(PersonDirectoryAttributeRepositoryPlanConfigurer.class.getSimpleName(), (Object)(rest.getState() == AttributeRepositoryStates.ACTIVE ? 1 : 0));
                if (StringUtils.isNotBlank((CharSequence)rest.getBasicAuthPassword()) && StringUtils.isNotBlank((CharSequence)rest.getBasicAuthUsername())) {
                    dao.setBasicAuthPassword(rest.getBasicAuthPassword());
                    dao.setBasicAuthUsername(rest.getBasicAuthUsername());
                    LOGGER.debug("Basic authentication credentials are located for REST endpoint [{}]", (Object)rest.getUrl());
                } else {
                    LOGGER.debug("Basic authentication credentials are not defined for REST endpoint [{}]", (Object)rest.getUrl());
                }
                LOGGER.debug("Configured REST attribute sources from [{}]", (Object)rest.getUrl());
                list.add(dao);
            });
            return BeanContainer.of(list);
        }
    }
}

