/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.BeanContainer;
import org.apereo.cas.util.spring.boot.ConditionalOnMultiValuedProperty;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.support.ScriptEnginePersonAttributeDao;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@ConditionalOnMultiValuedProperty(name="cas.authn.attribute-repository.script[0]", value={"location"})
@Configuration(value="CasPersonDirectoryScriptedConfiguration", proxyBeanMethods=false)
@Deprecated(since="6.2.0")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasPersonDirectoryScriptedConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasPersonDirectoryScriptedConfiguration.class);

    @Configuration(value="ScriptAttributeRepositoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class ScriptAttributeRepositoryPlanConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"scriptedPersonDirectoryAttributeRepositoryPlanConfigurer"})
        public PersonDirectoryAttributeRepositoryPlanConfigurer scriptedPersonDirectoryAttributeRepositoryPlanConfigurer(@Qualifier(value="scriptedAttributeRepositories") BeanContainer<IPersonAttributeDao> scriptedAttributeRepositories) {
            return plan -> plan.registerAttributeRepositories(scriptedAttributeRepositories.toList());
        }
    }

    @Configuration(value="ScriptAttributeRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class ScriptAttributeRepositoryConfiguration {
        @ConditionalOnMissingBean(name={"scriptedAttributeRepositories"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<IPersonAttributeDao> scriptedAttributeRepositories(CasConfigurationProperties casProperties) {
            ArrayList list = new ArrayList();
            casProperties.getAuthn().getAttributeRepository().getScript().forEach(Unchecked.consumer(script -> {
                String scriptContents = IOUtils.toString((InputStream)script.getLocation().getInputStream(), (Charset)StandardCharsets.UTF_8);
                String engineName = script.getEngineName() == null ? ScriptEnginePersonAttributeDao.getScriptEngineName((String)script.getLocation().getFilename()) : script.getEngineName();
                ScriptEnginePersonAttributeDao dao = new ScriptEnginePersonAttributeDao(scriptContents, engineName);
                dao.setCaseInsensitiveUsername(script.isCaseInsensitive());
                dao.setOrder(script.getOrder());
                FunctionUtils.doIfNotNull((Object)script.getId(), xva$0 -> dao.setId(new String[]{xva$0}));
                LOGGER.debug("Configured scripted attribute sources from [{}]", (Object)script.getLocation());
                list.add(dao);
            }));
            return BeanContainer.of(list);
        }
    }
}

