/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.Cache;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigurationContext;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.model.support.saml.idp.metadata.SamlIdPMetadataProperties;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.jpa.JpaBeanFactory;
import org.apereo.cas.support.saml.idp.metadata.JpaSamlIdPMetadataCipherExecutor;
import org.apereo.cas.support.saml.idp.metadata.JpaSamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.JpaSamlIdPMetadataLocator;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGeneratorConfigurationContext;
import org.apereo.cas.support.saml.idp.metadata.jpa.JpaSamlIdPMetadataDocumentFactory;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataLocator;
import org.apereo.cas.support.saml.services.idp.metadata.SamlIdPMetadataDocument;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.BeanContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.support.TransactionTemplate;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement
@ConditionalOnProperty(prefix="cas.authn.saml-idp.metadata.jpa", name={"idp-metadata-enabled"}, havingValue="true")
@Configuration(value="SamlIdPJpaIdPMetadataConfiguration", proxyBeanMethods=false)
public class SamlIdPJpaIdPMetadataConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPJpaIdPMetadataConfiguration.class);

    @Configuration(value="SamlIdPJpaIdPMetadataDataConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPJpaIdPMetadataDataConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"dataSourceSamlMetadataIdP"})
        public DataSource dataSourceSamlMetadataIdP(CasConfigurationProperties casProperties) {
            SamlIdPMetadataProperties idp = casProperties.getAuthn().getSamlIdp().getMetadata();
            return JpaBeans.newDataSource((AbstractJpaProperties)idp.getJpa());
        }
    }

    @Configuration(value="SamlIdPJpaIdPMetadataBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPJpaIdPMetadataBaseConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public CipherExecutor samlIdPMetadataGeneratorCipherExecutor(CasConfigurationProperties casProperties) {
            SamlIdPProperties idp = casProperties.getAuthn().getSamlIdp();
            EncryptionJwtSigningJwtCryptographyProperties crypto = idp.getMetadata().getJpa().getCrypto();
            if (crypto.isEnabled()) {
                return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, JpaSamlIdPMetadataCipherExecutor.class);
            }
            LOGGER.info("JPA SAML IdP metadata encryption/signing is turned off and MAY NOT be safe in a production environment. Consider using other choices to handle encryption, signing and verification of metadata artifacts");
            return CipherExecutor.noOp();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public SamlIdPMetadataLocator samlIdPMetadataLocator(@Qualifier(value="samlIdPMetadataCache") Cache<String, SamlIdPMetadataDocument> samlIdPMetadataCache, @Qualifier(value="samlIdPMetadataGeneratorCipherExecutor") CipherExecutor samlIdPMetadataGeneratorCipherExecutor) {
            return new JpaSamlIdPMetadataLocator((CipherExecutor<String, String>)samlIdPMetadataGeneratorCipherExecutor, samlIdPMetadataCache);
        }
    }

    @Configuration(value="SamlIdPJpaIdPMetadataGeneratorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPJpaIdPMetadataGeneratorConfiguration {
        @Bean
        public SamlIdPMetadataGenerator samlIdPMetadataGenerator(@Qualifier(value="transactionManagerSamlMetadataIdP") PlatformTransactionManager mgr, @Qualifier(value="samlIdPMetadataGeneratorConfigurationContext") SamlIdPMetadataGeneratorConfigurationContext samlIdPMetadataGeneratorConfigurationContext) {
            TransactionTemplate transactionTemplate = new TransactionTemplate(mgr);
            return new JpaSamlIdPMetadataGenerator(samlIdPMetadataGeneratorConfigurationContext, transactionTemplate);
        }
    }

    @Configuration(value="SamlIdPJpaIdPMetadataTransactionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPJpaIdPMetadataTransactionConfiguration {
        @Bean
        public PlatformTransactionManager transactionManagerSamlMetadataIdP(@Qualifier(value="samlMetadataIdPEntityManagerFactory") EntityManagerFactory emf) {
            JpaTransactionManager mgmr = new JpaTransactionManager();
            mgmr.setEntityManagerFactory(emf);
            return mgmr;
        }
    }

    @Configuration(value="SamlIdPJpaIdPMetadataEntityConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPJpaIdPMetadataEntityConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"jpaSamlMetadataIdPVendorAdapter"})
        public JpaVendorAdapter jpaSamlMetadataIdPVendorAdapter(CasConfigurationProperties casProperties, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) {
            return jpaBeanFactory.newJpaVendorAdapter(casProperties.getJdbc());
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<String> jpaSamlMetadataIdPPackagesToScan(CasConfigurationProperties casProperties) {
            SamlIdPMetadataProperties idp = casProperties.getAuthn().getSamlIdp().getMetadata();
            Class<SamlIdPMetadataDocument> type = new JpaSamlIdPMetadataDocumentFactory(idp.getJpa().getDialect()).getType();
            return BeanContainer.of((Set)CollectionUtils.wrapSet((Object)type.getPackage().getName()));
        }

        @Bean
        public LocalContainerEntityManagerFactoryBean samlMetadataIdPEntityManagerFactory(CasConfigurationProperties casProperties, @Qualifier(value="jpaSamlMetadataIdPVendorAdapter") JpaVendorAdapter jpaSamlMetadataIdPVendorAdapter, @Qualifier(value="dataSourceSamlMetadataIdP") DataSource dataSourceSamlMetadataIdP, @Qualifier(value="jpaSamlMetadataIdPPackagesToScan") BeanContainer<String> jpaSamlMetadataIdPPackagesToScan, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) {
            SamlIdPMetadataProperties idp = casProperties.getAuthn().getSamlIdp().getMetadata();
            JpaConfigurationContext ctx = JpaConfigurationContext.builder().jpaVendorAdapter(jpaSamlMetadataIdPVendorAdapter).persistenceUnitName("jpaSamlMetadataIdPContext").dataSource(dataSourceSamlMetadataIdP).packagesToScan(jpaSamlMetadataIdPPackagesToScan.toSet()).build();
            return jpaBeanFactory.newEntityManagerFactoryBean(ctx, (AbstractJpaProperties)idp.getJpa());
        }
    }
}

