/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.Cache;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigurationContext;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.model.support.saml.idp.metadata.SamlIdPMetadataProperties;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.jpa.JpaBeanFactory;
import org.apereo.cas.support.saml.idp.metadata.JpaSamlIdPMetadataCipherExecutor;
import org.apereo.cas.support.saml.idp.metadata.JpaSamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.JpaSamlIdPMetadataLocator;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGeneratorConfigurationContext;
import org.apereo.cas.support.saml.idp.metadata.jpa.JpaSamlIdPMetadataDocumentFactory;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataLocator;
import org.apereo.cas.support.saml.services.idp.metadata.SamlIdPMetadataDocument;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.integration.transaction.PseudoTransactionManager;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.transaction.support.TransactionTemplate;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement(proxyTargetClass=false)
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.SAMLIdentityProviderMetadata, module="jpa")
@AutoConfiguration
public class SamlIdPJpaIdPMetadataConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPJpaIdPMetadataConfiguration.class);
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.saml-idp.metadata.jpa.idp-metadata-enabled").isTrue();

    @Configuration(value="SamlIdPJpaIdPMetadataDataConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPJpaIdPMetadataDataConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"dataSourceSamlMetadataIdP"})
        public DataSource dataSourceSamlMetadataIdP(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (DataSource)BeanSupplier.of(DataSource.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                SamlIdPMetadataProperties idp = casProperties.getAuthn().getSamlIdp().getMetadata();
                return JpaBeans.newDataSource((AbstractJpaProperties)idp.getJpa());
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="SamlIdPJpaIdPMetadataBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPJpaIdPMetadataBaseConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public CipherExecutor samlIdPMetadataGeneratorCipherExecutor(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (CipherExecutor)BeanSupplier.of(CipherExecutor.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                SamlIdPProperties idp = casProperties.getAuthn().getSamlIdp();
                EncryptionJwtSigningJwtCryptographyProperties crypto = idp.getMetadata().getJpa().getCrypto();
                if (crypto.isEnabled()) {
                    return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, JpaSamlIdPMetadataCipherExecutor.class);
                }
                LOGGER.info("JPA SAML IdP metadata encryption/signing is turned off and MAY NOT be safe in a production environment. Consider using other choices to handle encryption, signing and verification of metadata artifacts");
                return CipherExecutor.noOp();
            }).otherwise(CipherExecutor::noOp).get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public SamlIdPMetadataLocator samlIdPMetadataLocator(ConfigurableApplicationContext applicationContext, @Qualifier(value="samlIdPMetadataCache") Cache<String, SamlIdPMetadataDocument> samlIdPMetadataCache, @Qualifier(value="samlIdPMetadataGeneratorCipherExecutor") CipherExecutor samlIdPMetadataGeneratorCipherExecutor) {
            return (SamlIdPMetadataLocator)BeanSupplier.of(SamlIdPMetadataLocator.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new JpaSamlIdPMetadataLocator((CipherExecutor<String, String>)samlIdPMetadataGeneratorCipherExecutor, samlIdPMetadataCache)).otherwiseProxy().get();
        }
    }

    @Configuration(value="SamlIdPJpaIdPMetadataGeneratorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPJpaIdPMetadataGeneratorConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SamlIdPMetadataGenerator samlIdPMetadataGenerator(ConfigurableApplicationContext applicationContext, @Qualifier(value="transactionManagerSamlMetadataIdP") PlatformTransactionManager mgr, @Qualifier(value="samlIdPMetadataGeneratorConfigurationContext") SamlIdPMetadataGeneratorConfigurationContext ctx) {
            return (SamlIdPMetadataGenerator)BeanSupplier.of(SamlIdPMetadataGenerator.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                TransactionTemplate transactionTemplate = new TransactionTemplate(mgr);
                return new JpaSamlIdPMetadataGenerator(ctx, (TransactionOperations)transactionTemplate);
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="SamlIdPJpaIdPMetadataTransactionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPJpaIdPMetadataTransactionConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PlatformTransactionManager transactionManagerSamlMetadataIdP(ConfigurableApplicationContext applicationContext, @Qualifier(value="samlMetadataIdPEntityManagerFactory") EntityManagerFactory emf) {
            return (PlatformTransactionManager)BeanSupplier.of(PlatformTransactionManager.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(Unchecked.supplier(() -> {
                JpaTransactionManager mgmr = new JpaTransactionManager();
                mgmr.setEntityManagerFactory(emf);
                return mgmr;
            })).otherwise(PseudoTransactionManager::new).get();
        }
    }

    @Configuration(value="SamlIdPJpaIdPMetadataEntityConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPJpaIdPMetadataEntityConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"jpaSamlMetadataIdPVendorAdapter"})
        public JpaVendorAdapter jpaSamlMetadataIdPVendorAdapter(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) {
            return (JpaVendorAdapter)BeanSupplier.of(JpaVendorAdapter.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> jpaBeanFactory.newJpaVendorAdapter(casProperties.getJdbc())).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<String> jpaSamlMetadataIdPPackagesToScan(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (BeanContainer)BeanSupplier.of(BeanContainer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                SamlIdPMetadataProperties idp = casProperties.getAuthn().getSamlIdp().getMetadata();
                Class<SamlIdPMetadataDocument> type = new JpaSamlIdPMetadataDocumentFactory(idp.getJpa().getDialect()).getType();
                return BeanContainer.of((Set)CollectionUtils.wrapSet((Object)type.getPackage().getName()));
            }).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public EntityManagerFactory samlMetadataIdPEntityManagerFactory(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="jpaSamlMetadataIdPVendorAdapter") JpaVendorAdapter jpaSamlMetadataIdPVendorAdapter, @Qualifier(value="dataSourceSamlMetadataIdP") DataSource dataSourceSamlMetadataIdP, @Qualifier(value="jpaSamlMetadataIdPPackagesToScan") BeanContainer<String> jpaSamlMetadataIdPPackagesToScan, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) throws Exception {
            return (EntityManagerFactory)BeanSupplier.of(EntityManagerFactory.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(Unchecked.supplier(() -> {
                SamlIdPMetadataProperties idp = casProperties.getAuthn().getSamlIdp().getMetadata();
                JpaConfigurationContext ctx = JpaConfigurationContext.builder().jpaVendorAdapter(jpaSamlMetadataIdPVendorAdapter).persistenceUnitName("jpaSamlMetadataIdPContext").dataSource(dataSourceSamlMetadataIdP).packagesToScan(jpaSamlMetadataIdPPackagesToScan.toSet()).build();
                return (EntityManagerFactory)jpaBeanFactory.newEntityManagerFactoryBean(ctx, (AbstractJpaProperties)idp.getJpa()).getObject();
            })).otherwiseProxy().get();
        }
    }
}

