/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.idp.metadata;

import com.github.benmanes.caffeine.cache.Cache;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import lombok.Generated;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.locator.AbstractSamlIdPMetadataLocator;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlIdPMetadataDocument;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Transactional;

@EnableTransactionManagement(proxyTargetClass=false)
@Transactional(transactionManager="transactionManagerSamlMetadataIdP")
public class JpaSamlIdPMetadataLocator
extends AbstractSamlIdPMetadataLocator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaSamlIdPMetadataLocator.class);
    @PersistenceContext(unitName="samlMetadataIdPEntityManagerFactory")
    private EntityManager entityManager;

    public JpaSamlIdPMetadataLocator(CipherExecutor<String, String> metadataCipherExecutor, Cache<String, SamlIdPMetadataDocument> metadataCache) {
        super(metadataCipherExecutor, metadataCache);
    }

    public SamlIdPMetadataDocument fetchInternal(Optional<SamlRegisteredService> registeredService) throws Exception {
        try {
            TypedQuery<SamlIdPMetadataDocument> query;
            List results;
            if (registeredService.isPresent() && !(results = (query = this.buildQuery(registeredService)).getResultList()).isEmpty()) {
                return (SamlIdPMetadataDocument)results.get(0);
            }
            return (SamlIdPMetadataDocument)this.buildQuery(Optional.empty()).getSingleResult();
        }
        catch (NoResultException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return new SamlIdPMetadataDocument();
        }
    }

    protected TypedQuery<SamlIdPMetadataDocument> buildQuery(Optional<SamlRegisteredService> registeredService) {
        Object sql = "SELECT r FROM SamlIdPMetadataDocument r ";
        if (registeredService.isPresent()) {
            sql = (String)sql + " WHERE r.appliesTo = :appliesTo";
        }
        TypedQuery query = this.getEntityManager().createQuery((String)sql, SamlIdPMetadataDocument.class);
        if (registeredService.isPresent()) {
            query.setParameter("appliesTo", (Object)SamlIdPMetadataGenerator.getAppliesToFor(registeredService));
        }
        return query.setMaxResults(1);
    }

    @Generated
    public EntityManager getEntityManager() {
        return this.entityManager;
    }
}

