/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.query;

import java.io.StringWriter;
import java.util.Objects;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicket;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketFactory;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketImpl;
import org.apereo.cas.util.CollectionUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;

public class DefaultSamlAttributeQueryTicketFactory
implements SamlAttributeQueryTicketFactory {
    protected final ExpirationPolicyBuilder expirationPolicy;
    protected final ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    protected final OpenSamlConfigBean configBean;

    @Override
    public SamlAttributeQueryTicket create(String id, SAMLObject samlObject, String relyingParty, TicketGrantingTicket ticketGrantingTicket) {
        SamlAttributeQueryTicketImpl samlAttributeQueryTicketImpl;
        block8: {
            StringWriter w = SamlUtils.transformSamlObject((OpenSamlConfigBean)this.configBean, (XMLObject)samlObject);
            try {
                String codeId = this.createTicketIdFor(id, relyingParty);
                WebApplicationService service = (WebApplicationService)this.webApplicationServiceFactory.createService(relyingParty);
                service.getAttributes().put(TicketGrantingTicket.class.getSimpleName(), CollectionUtils.wrapList((Object[])new Object[]{ticketGrantingTicket.getId()}));
                service.getAttributes().put(RegisteredService.class.getSimpleName(), CollectionUtils.wrapList((Object[])new Object[]{relyingParty}));
                service.getAttributes().put("owner", CollectionUtils.wrapList((Object[])new Object[]{this.getTicketType().getName()}));
                samlAttributeQueryTicketImpl = new SamlAttributeQueryTicketImpl(codeId, (Service)service, this.expirationPolicy.buildTicketExpirationPolicy(), relyingParty, w.toString(), Objects.requireNonNull(ticketGrantingTicket).getAuthentication());
                if (w == null) break block8;
            }
            catch (Throwable throwable) {
                if (w != null) {
                    try {
                        w.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            w.close();
        }
        return samlAttributeQueryTicketImpl;
    }

    public Class<? extends Ticket> getTicketType() {
        return SamlAttributeQueryTicket.class;
    }

    @Generated
    public DefaultSamlAttributeQueryTicketFactory(ExpirationPolicyBuilder expirationPolicy, ServiceFactory<WebApplicationService> webApplicationServiceFactory, OpenSamlConfigBean configBean) {
        this.expirationPolicy = expirationPolicy;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.configBean = configBean;
    }
}

