/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.authn;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.web.idp.profile.builders.AuthenticatedAssertionContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.authn.AuthnContextClassRefBuilder;
import org.apereo.cas.util.CollectionUtils;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthnContextClassRefBuilder
implements AuthnContextClassRefBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAuthnContextClassRefBuilder.class);
    private final CasConfigurationProperties casProperties;

    @Override
    public String build(AuthenticatedAssertionContext assertion, RequestAbstractType authnRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, SamlRegisteredService service) {
        RequestedAuthnContext requestedAuthnContext;
        if (StringUtils.isNotBlank((CharSequence)service.getRequiredAuthenticationContextClass())) {
            LOGGER.debug("Using [{}] as indicated by SAML registered service [{}]", (Object)service.getRequiredAuthenticationContextClass(), (Object)service.getName());
            return service.getRequiredAuthenticationContextClass();
        }
        String defClass = (String)StringUtils.defaultIfBlank((CharSequence)this.casProperties.getAuthn().getSamlIdp().getResponse().getDefaultAuthenticationContextClass(), (CharSequence)"urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
        RequestedAuthnContext requestedAuthnContext2 = requestedAuthnContext = authnRequest instanceof AuthnRequest ? ((AuthnRequest)AuthnRequest.class.cast(authnRequest)).getRequestedAuthnContext() : null;
        if (requestedAuthnContext == null) {
            LOGGER.debug("No specific authN context is requested. Returning [{}]", (Object)defClass);
            return defClass;
        }
        List authnContextClassRefs = requestedAuthnContext.getAuthnContextClassRefs();
        if (authnContextClassRefs == null || authnContextClassRefs.isEmpty()) {
            LOGGER.debug("Requested authN context class ref is unspecified. Returning [{}]", (Object)defClass);
            return defClass;
        }
        String contextInAssertion = this.getAuthenticationContextByAssertion(assertion, requestedAuthnContext, authnContextClassRefs);
        String finalCtx = (String)StringUtils.defaultIfBlank((CharSequence)contextInAssertion, (CharSequence)defClass);
        LOGGER.debug("Returning authN context [{}]", (Object)finalCtx);
        return finalCtx;
    }

    protected String getAuthenticationContextByAssertion(AuthenticatedAssertionContext assertion, RequestedAuthnContext requestedAuthnContext, List<AuthnContextClassRef> authnContextClassRefs) {
        LOGGER.debug("AuthN Context comparison is requested to use [{}]", (Object)requestedAuthnContext.getComparison());
        authnContextClassRefs.forEach(c -> LOGGER.debug("Requested AuthN Context [{}]", (Object)c.getURI()));
        List authnContexts = this.casProperties.getAuthn().getSamlIdp().getCore().getAuthenticationContextClassMappings();
        Map definedContexts = CollectionUtils.convertDirectedListToMap((Collection)authnContexts);
        Pair mappedMethod = authnContextClassRefs.stream().filter(ref -> StringUtils.isNotBlank((CharSequence)ref.getURI())).filter(ref -> definedContexts.containsKey(ref.getURI())).map(ref -> Pair.of((Object)ref, (Object)((String)definedContexts.get(ref.getURI())))).findFirst().orElse(null);
        Map<String, Object> attributes = assertion.getAttributes();
        String contextAttribute = this.casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute();
        if (attributes.containsKey(contextAttribute) && mappedMethod != null) {
            Object authnContext = attributes.get(contextAttribute);
            String satisfiedContext = CollectionUtils.firstElement((Object)authnContext).map(Object::toString).orElse(null);
            if (StringUtils.equals((CharSequence)((CharSequence)mappedMethod.getValue()), (CharSequence)satisfiedContext)) {
                return ((AuthnContextClassRef)mappedMethod.getLeft()).getURI();
            }
        }
        return null;
    }

    @Generated
    public DefaultAuthnContextClassRefBuilder(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }
}

