/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.enc.encoder;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.velocity.app.VelocityEngine;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.saml2.binding.encoding.impl.BaseSAML2MessageEncoder;
import org.opensaml.saml.saml2.core.RequestAbstractType;

public abstract class BaseHttpServletAwareSamlObjectEncoder<T extends SAMLObject> {
    protected final VelocityEngine velocityEngineFactory;
    protected final SamlRegisteredServiceServiceProviderMetadataFacade adaptor;
    protected final HttpServletResponse httpResponse;
    protected final HttpServletRequest httpRequest;

    public final T encode(RequestAbstractType request, T samlObject, String relayState, MessageContext messageContext) throws SamlException {
        if (this.httpResponse != null) {
            BaseSAML2MessageEncoder encoder = this.getMessageEncoderInstance();
            encoder.setHttpServletResponse(this.httpResponse);
            MessageContext ctx = this.getEncoderMessageContext(request, samlObject, relayState, messageContext);
            encoder.setMessageContext(ctx);
            this.finalizeEncode(request, encoder, samlObject, relayState, messageContext);
        }
        return samlObject;
    }

    protected MessageContext getEncoderMessageContext(RequestAbstractType request, T samlObject, String relayState, MessageContext messageContext) {
        MessageContext ctx = new MessageContext();
        ctx.setMessage(samlObject);
        ctx.addSubcontext(messageContext.getSubcontext(SAMLBindingContext.class, true));
        SAMLBindingSupport.setRelayState((MessageContext)ctx, (String)relayState);
        SamlIdPUtils.preparePeerEntitySamlEndpointContext((Pair)Pair.of((Object)request, (Object)messageContext), (MessageContext)ctx, (SamlRegisteredServiceServiceProviderMetadataFacade)this.adaptor, (String)this.getBinding());
        SAMLSelfEntityContext self = (SAMLSelfEntityContext)ctx.getSubcontext(SAMLSelfEntityContext.class, true);
        self.setEntityId(SamlIdPUtils.getIssuerFromSamlObject(samlObject));
        return ctx;
    }

    protected void finalizeEncode(RequestAbstractType authnRequest, BaseSAML2MessageEncoder encoder, T samlResponse, String relayState, MessageContext messageContext) {
        encoder.initialize();
        encoder.encode();
    }

    protected abstract String getBinding();

    protected abstract BaseSAML2MessageEncoder getMessageEncoderInstance();

    @Generated
    protected BaseHttpServletAwareSamlObjectEncoder(VelocityEngine velocityEngineFactory, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, HttpServletResponse httpResponse, HttpServletRequest httpRequest) {
        this.velocityEngineFactory = velocityEngineFactory;
        this.adaptor = adaptor;
        this.httpResponse = httpResponse;
        this.httpRequest = httpRequest;
    }
}

