/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.nameid;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.PersistentIdGenerator;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.AuthenticatedAssertionContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectEncrypter;
import org.apereo.cas.support.saml.web.idp.profile.builders.nameid.SamlAttributeBasedNameIdGenerator;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.profile.SAML2NameIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlProfileSamlNameIdBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<SAMLObject> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSamlNameIdBuilder.class);
    private static final long serialVersionUID = -6231886395225437320L;
    private final PersistentIdGenerator persistentIdGenerator;
    private final MetadataResolver samlIdPMetadataResolver;
    private final SamlIdPObjectEncrypter samlIdPObjectEncrypter;

    public SamlProfileSamlNameIdBuilder(OpenSamlConfigBean configBean, PersistentIdGenerator persistentIdGenerator, MetadataResolver samlIdPMetadataResolver, SamlIdPObjectEncrypter samlIdPObjectEncrypter) {
        super(configBean);
        this.persistentIdGenerator = persistentIdGenerator;
        this.samlIdPMetadataResolver = samlIdPMetadataResolver;
        this.samlIdPObjectEncrypter = samlIdPObjectEncrypter;
    }

    protected static List<String> getSupportedNameIdFormats(SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) {
        ArrayList<String> supportedNameFormats = new ArrayList<String>(adaptor.getSupportedNameIdFormats());
        LOGGER.debug("Metadata for [{}] declares the following NameIDs [{}]", (Object)adaptor.getEntityId(), supportedNameFormats);
        if (supportedNameFormats.isEmpty()) {
            supportedNameFormats.add("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
            LOGGER.debug("No supported nameId formats could be determined from metadata. Added default [{}]", (Object)"urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        }
        if (StringUtils.isNotBlank((CharSequence)service.getRequiredNameIdFormat())) {
            String fmt = SamlProfileSamlNameIdBuilder.parseAndBuildRequiredNameIdFormat(service);
            supportedNameFormats.add(0, fmt);
            LOGGER.debug("Added required nameId format [{}] based on saml service configuration for [{}]", (Object)fmt, (Object)service.getServiceId());
        }
        return supportedNameFormats;
    }

    private static String parseAndBuildRequiredNameIdFormat(SamlRegisteredService service) {
        String fmt = StringUtils.defaultString((String)service.getRequiredNameIdFormat(), (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified").trim();
        LOGGER.debug("Required NameID format assigned to service [{}] is [{}]", (Object)service.getName(), (Object)fmt);
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:2.0:nameid-format:transient", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:2.0:nameid-format:transient";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:2.0:nameid-format:entity", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:2.0:nameid-format:entity";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)"urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted", (CharSequence)fmt)) {
            return "urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted";
        }
        return "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
    }

    protected static String getRequiredNameIdFormatIfAny(RequestAbstractType authnRequest) {
        String requiredNameFormat = SamlIdPUtils.getNameIDPolicy((RequestAbstractType)authnRequest).map(NameIDPolicy::getFormat).orElse(null);
        LOGGER.debug("AuthN request indicates [{}] is the required NameID format", (Object)requiredNameFormat);
        return requiredNameFormat;
    }

    @Override
    public SAMLObject build(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, AuthenticatedAssertionContext assertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext) throws SamlException {
        if (authnRequest instanceof AttributeQuery) {
            return this.determineNameIdForAttributeQuery((AttributeQuery)authnRequest, service, adaptor);
        }
        return this.buildNameId(authnRequest, assertion, service, adaptor, messageContext, request);
    }

    protected NameID buildNameId(RequestAbstractType authnRequest, AuthenticatedAssertionContext assertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, MessageContext messageContext, HttpServletRequest request) throws SamlException {
        List<String> supportedNameFormats = SamlProfileSamlNameIdBuilder.getSupportedNameIdFormats(service, adaptor);
        String requiredNameFormat = SamlProfileSamlNameIdBuilder.getRequiredNameIdFormatIfAny(authnRequest);
        this.validateRequiredNameIdFormatIfAny(authnRequest, adaptor, supportedNameFormats, requiredNameFormat);
        NameID nameID = this.determineNameId(authnRequest, assertion, supportedNameFormats, service, adaptor, request);
        return this.finalizeNameId(nameID, authnRequest, assertion, supportedNameFormats, service, adaptor, request);
    }

    protected NameID finalizeNameId(NameID nameid, RequestAbstractType authnRequest, AuthenticatedAssertionContext assertion, List<String> supportedNameFormats, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, HttpServletRequest request) {
        if (nameid != null) {
            if (StringUtils.isNotBlank((CharSequence)service.getNameIdQualifier())) {
                nameid.setNameQualifier(service.getNameIdQualifier());
            } else {
                nameid.setNameQualifier(SamlIdPUtils.determineNameIdNameQualifier((SamlRegisteredService)service, (MetadataResolver)this.samlIdPMetadataResolver));
            }
            FunctionUtils.doIf((boolean)StringUtils.isNotBlank((CharSequence)service.getServiceProviderNameIdQualifier()), value -> nameid.setSPNameQualifier(service.getServiceProviderNameIdQualifier()), value -> nameid.setSPNameQualifier(adaptor.getEntityId())).accept(service);
        }
        return nameid;
    }

    protected void validateRequiredNameIdFormatIfAny(RequestAbstractType authnRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, List<String> supportedNameFormats, String requiredNameFormat) {
        if (StringUtils.isNotBlank((CharSequence)requiredNameFormat) && !supportedNameFormats.contains(requiredNameFormat)) {
            LOGGER.warn("Required NameID format [{}] in the AuthN request issued by [{}] is not supported based on the metadata for [{}]. The requested NameID format may not be honored. You should consult the metadata for this service and ensure the requested NameID format is present in the collection of supported metadata formats in the metadata, which are the following: [{}]", new Object[]{requiredNameFormat, SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest), adaptor.getEntityId(), adaptor.getSupportedNameIdFormats()});
        }
    }

    protected NameID determineNameId(RequestAbstractType authnRequest, AuthenticatedAssertionContext assertion, List<String> supportedNameFormats, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, HttpServletRequest request) {
        for (String nameFormat : supportedNameFormats) {
            LOGGER.debug("Evaluating NameID format [{}]", (Object)nameFormat);
            NameID nameId = this.encodeNameIdBasedOnNameFormat(authnRequest, assertion, nameFormat, service, adaptor, request);
            if (nameId == null) continue;
            LOGGER.debug("Determined NameID based on format [{}] to be [{}]", (Object)nameFormat, (Object)nameId.getValue());
            return nameId;
        }
        LOGGER.warn("No NameID could be determined based on the supported formats [{}]", supportedNameFormats);
        return null;
    }

    protected NameID encodeNameIdBasedOnNameFormat(RequestAbstractType authnRequest, AuthenticatedAssertionContext assertion, String nameFormat, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, HttpServletRequest request) {
        try {
            String attribute = this.prepareNameIdAttribute(assertion, nameFormat, adaptor, service);
            SAML2NameIDGenerator encoder = SamlAttributeBasedNameIdGenerator.get(Optional.of(authnRequest), nameFormat, service, attribute);
            request.setAttribute(NameID.class.getName(), (Object)attribute);
            LOGGER.debug("Encoding NameID based on [{}]", (Object)nameFormat);
            ProfileRequestContext prc = new ProfileRequestContext();
            NameID nameId = Objects.requireNonNull(encoder.generate(prc, nameFormat));
            LOGGER.debug("Final NameID encoded with format [{}] has value [{}]", (Object)nameId.getFormat(), (Object)nameId.getValue());
            return nameId;
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return null;
        }
    }

    protected String prepareNameIdAttribute(AuthenticatedAssertionContext assertion, String nameFormat, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, SamlRegisteredService registeredService) {
        LOGGER.debug("Preparing NameID attribute for principal [{}]", (Object)assertion.getName());
        String nameIdValue = this.getNameIdValueFromNameFormat(nameFormat, adaptor, assertion.getName(), registeredService);
        LOGGER.debug("NameID attribute value is set to [{}]", (Object)nameIdValue);
        return nameIdValue;
    }

    private String getNameIdValueFromNameFormat(String nameFormat, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String principalName, SamlRegisteredService registeredService) {
        if (nameFormat.trim().equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:nameid-format:transient")) {
            String entityId = adaptor.getEntityId();
            if (registeredService.isSkipGeneratingTransientNameId()) {
                LOGGER.debug("Generation of transient NameID value is skipped for [{}] and [{}] will be used instead", (Object)entityId, (Object)principalName);
            } else {
                LOGGER.debug("Generating transient NameID value for principal [{}] and entity id [{}]", (Object)principalName, (Object)entityId);
                return this.persistentIdGenerator.generate(principalName, entityId);
            }
        }
        return principalName;
    }

    private SAMLObject determineNameIdForAttributeQuery(AttributeQuery query, SamlRegisteredService registeredService, SamlRegisteredServiceServiceProviderMetadataFacade facade) {
        NameID result = query.getSubject().getNameID() == null ? this.samlIdPObjectEncrypter.decode(query.getSubject().getEncryptedID(), registeredService, facade) : query.getSubject().getNameID();
        result.detach();
        return result;
    }
}

