/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.subject;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.AuthenticatedAssertionContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectEncrypter;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlProfileSamlSubjectBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<Subject> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSamlSubjectBuilder.class);
    private static final long serialVersionUID = 4782621942035583007L;
    private final SamlProfileObjectBuilder<SAMLObject> ssoPostProfileSamlNameIdBuilder;
    private final CasConfigurationProperties casProperties;
    private final transient SamlIdPObjectEncrypter samlObjectEncrypter;

    public SamlProfileSamlSubjectBuilder(OpenSamlConfigBean configBean, SamlProfileObjectBuilder<SAMLObject> ssoPostProfileSamlNameIdBuilder, CasConfigurationProperties casProperties, SamlIdPObjectEncrypter samlObjectEncrypter) {
        super(configBean);
        this.ssoPostProfileSamlNameIdBuilder = ssoPostProfileSamlNameIdBuilder;
        this.samlObjectEncrypter = samlObjectEncrypter;
        this.casProperties = casProperties;
    }

    @Override
    public Subject build(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, AuthenticatedAssertionContext assertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext) throws SamlException {
        return this.buildSubject(request, response, authnRequest, assertion, service, adaptor, binding, messageContext);
    }

    private Subject buildSubject(HttpServletRequest request, HttpServletResponse response, RequestAbstractType authnRequest, AuthenticatedAssertionContext assertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext) throws SamlException {
        SAMLObject subjectConfNameId;
        ZonedDateTime validFromDate = ZonedDateTime.now(ZoneOffset.UTC);
        LOGGER.trace("Locating the assertion consumer service url for binding [{}]", (Object)binding);
        Endpoint acs = SamlIdPUtils.determineEndpointForRequest((Pair)Pair.of((Object)authnRequest, (Object)messageContext), (SamlRegisteredServiceServiceProviderMetadataFacade)adaptor, (String)binding);
        String location = StringUtils.isBlank((CharSequence)acs.getResponseLocation()) ? acs.getLocation() : acs.getResponseLocation();
        SAMLObject subjectNameId = this.getNameIdForService(request, response, authnRequest, service, adaptor, binding, assertion, messageContext);
        SAMLObject sAMLObject = subjectConfNameId = service.isSkipGeneratingSubjectConfirmationNameId() ? null : this.getNameIdForService(request, response, authnRequest, service, adaptor, binding, assertion, messageContext);
        ZonedDateTime notOnOrAfter = service.isSkipGeneratingSubjectConfirmationNotOnOrAfter() ? null : validFromDate.plusSeconds(service.getSkewAllowance() > 0 ? (long)service.getSkewAllowance() : Beans.newDuration((String)this.casProperties.getAuthn().getSamlIdp().getResponse().getSkewAllowance()).toSeconds());
        SAMLObject finalSubjectNameId = this.encryptNameIdIfNecessary(subjectNameId, service, adaptor);
        SAMLObject finalSubjectConfigNameId = this.encryptNameIdIfNecessary(subjectConfNameId, service, adaptor);
        Subject subject = this.newSubject(finalSubjectNameId, finalSubjectConfigNameId, service.isSkipGeneratingSubjectConfirmationRecipient() ? null : location, notOnOrAfter, service.isSkipGeneratingSubjectConfirmationInResponseTo() ? null : authnRequest.getID(), service.isSkipGeneratingSubjectConfirmationNotBefore() ? null : ZonedDateTime.now(ZoneOffset.UTC));
        LOGGER.debug("Created SAML subject [{}]", (Object)subject);
        return subject;
    }

    private SAMLObject getNameIdForService(HttpServletRequest request, HttpServletResponse response, RequestAbstractType authnRequest, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, AuthenticatedAssertionContext assertion, MessageContext messageContext) {
        if (service.isSkipGeneratingAssertionNameId()) {
            LOGGER.warn("Assertion will skip assigning/generating a nameId based on service [{}]", (Object)service);
            return null;
        }
        return this.ssoPostProfileSamlNameIdBuilder.build(authnRequest, request, response, assertion, service, adaptor, binding, messageContext);
    }

    private SAMLObject encryptNameIdIfNecessary(SAMLObject subjectNameId, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) {
        if (!(subjectNameId instanceof EncryptedID) && subjectNameId instanceof NameID && "urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted".equalsIgnoreCase(((NameID)subjectNameId).getFormat())) {
            return this.samlObjectEncrypter.encode((NameID)subjectNameId, service, adaptor);
        }
        return subjectNameId;
    }
}

