/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.sso;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.AuthenticatedAssertionContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.ScratchContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.impl.AuthnRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

@RestControllerEndpoint(id="samlPostProfileResponse", enableByDefault=false)
public class SSOSamlIdPPostProfileHandlerEndpoint
extends BaseCasActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SSOSamlIdPPostProfileHandlerEndpoint.class);
    private final ServicesManager servicesManager;
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final ServiceFactory<WebApplicationService> serviceFactory;
    private final PrincipalFactory principalFactory;
    private final SamlProfileObjectBuilder<? extends SAMLObject> responseBuilder;
    private final SamlRegisteredServiceCachingMetadataResolver defaultSamlRegisteredServiceCachingMetadataResolver;
    private final AbstractSaml20ObjectBuilder saml20ObjectBuilder;

    public SSOSamlIdPPostProfileHandlerEndpoint(CasConfigurationProperties casProperties, ServicesManager servicesManager, AuthenticationSystemSupport authenticationSystemSupport, ServiceFactory<WebApplicationService> serviceFactory, PrincipalFactory principalFactory, SamlProfileObjectBuilder<? extends SAMLObject> responseBuilder, SamlRegisteredServiceCachingMetadataResolver cachingMetadataResolver, AbstractSaml20ObjectBuilder saml20ObjectBuilder) {
        super(casProperties);
        this.servicesManager = servicesManager;
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.serviceFactory = serviceFactory;
        this.principalFactory = principalFactory;
        this.responseBuilder = responseBuilder;
        this.defaultSamlRegisteredServiceCachingMetadataResolver = cachingMetadataResolver;
        this.saml20ObjectBuilder = saml20ObjectBuilder;
    }

    @GetMapping(produces={"application/xml"})
    @ResponseBody
    @Operation(summary="Produce SAML2 response entity", parameters={@Parameter(name="username", required=true), @Parameter(name="password", required=true), @Parameter(name="entityId", required=true), @Parameter(name="encrypt")})
    public ResponseEntity<Object> produceGet(HttpServletRequest request, HttpServletResponse response) {
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        String entityId = request.getParameter("entityId");
        boolean encrypt = Boolean.parseBoolean(request.getParameter("encrypt"));
        return this.produce(request, response, username, password, entityId, encrypt);
    }

    @PostMapping(produces={"application/xml"})
    @ResponseBody
    @Operation(summary="Produce SAML2 response entity", parameters={@Parameter(name="username", required=true), @Parameter(name="password", required=true), @Parameter(name="entityId", required=true), @Parameter(name="encrypt")})
    public ResponseEntity<Object> producePost(HttpServletRequest request, HttpServletResponse response, @RequestBody Map<String, String> map) {
        String username = map.get("username");
        String password = map.get("password");
        String entityId = map.get("entityId");
        boolean encrypt = Boolean.parseBoolean(map.get("encrypt"));
        return this.produce(request, response, username, password, entityId, encrypt);
    }

    private ResponseEntity<Object> produce(HttpServletRequest request, HttpServletResponse response, String username, String password, String entityId, boolean encrypt) {
        try {
            WebApplicationService selectedService = (WebApplicationService)this.serviceFactory.createService(entityId);
            SamlRegisteredService registeredService = (SamlRegisteredService)this.servicesManager.findServiceBy((Service)selectedService, SamlRegisteredService.class);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)registeredService);
            SamlRegisteredService loadedService = (SamlRegisteredService)BeanUtils.cloneBean((Object)registeredService);
            loadedService.setEncryptAssertions(encrypt);
            loadedService.setEncryptAttributes(encrypt);
            AuthnRequest authnRequest = new AuthnRequestBuilder().buildObject();
            authnRequest.setIssuer(this.saml20ObjectBuilder.newIssuer(entityId));
            Optional adaptorResult = SamlRegisteredServiceServiceProviderMetadataFacade.get((SamlRegisteredServiceCachingMetadataResolver)this.defaultSamlRegisteredServiceCachingMetadataResolver, (SamlRegisteredService)loadedService, (String)entityId);
            if (adaptorResult.isPresent()) {
                SamlRegisteredServiceServiceProviderMetadataFacade adaptor = (SamlRegisteredServiceServiceProviderMetadataFacade)adaptorResult.get();
                MessageContext messageContext = new MessageContext();
                ScratchContext scratch = (ScratchContext)messageContext.getSubcontext(ScratchContext.class, true);
                Map map = Objects.requireNonNull(scratch).getMap();
                map.put("encodeSamlResponse", Boolean.FALSE);
                AuthenticatedAssertionContext assertion = this.getAssertion(username, password, entityId);
                SAMLObject object = this.responseBuilder.build((RequestAbstractType)authnRequest, request, response, assertion, loadedService, adaptor, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", messageContext);
                String encoded = SamlUtils.transformSamlObject((OpenSamlConfigBean)this.saml20ObjectBuilder.getOpenSamlConfigBean(), (XMLObject)object, (boolean)true).toString();
                return new ResponseEntity((Object)encoded, HttpStatus.OK);
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return new ResponseEntity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage()), HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private AuthenticatedAssertionContext getAssertion(String username, String password, String entityId) {
        WebApplicationService selectedService = (WebApplicationService)this.serviceFactory.createService(entityId);
        SamlRegisteredService registeredService = (SamlRegisteredService)this.servicesManager.findServiceBy((Service)selectedService, SamlRegisteredService.class);
        UsernamePasswordCredential credential = new UsernamePasswordCredential(username, password);
        AuthenticationResult result = this.authenticationSystemSupport.finalizeAuthenticationTransaction((Service)selectedService, new Credential[]{credential});
        Authentication authentication = result.getAuthentication();
        Principal principal = authentication.getPrincipal();
        RegisteredServiceAttributeReleasePolicyContext context = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)registeredService).service((Service)selectedService).principal(principal).build();
        Map attributesToRelease = registeredService.getAttributeReleasePolicy().getAttributes(context);
        AuthenticationBuilder builder = DefaultAuthenticationBuilder.of((Principal)principal, (PrincipalFactory)this.principalFactory, (Map)attributesToRelease, (Service)selectedService, (RegisteredService)registeredService, (Authentication)authentication);
        Authentication finalAuthentication = builder.build();
        Principal authnPrincipal = finalAuthentication.getPrincipal();
        return ((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)AuthenticatedAssertionContext.builder().name(authnPrincipal.getId())).attributes(CollectionUtils.merge((Map[])new Map[]{authnPrincipal.getAttributes(), finalAuthentication.getAttributes()}))).build();
    }
}

