/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.enc;

import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPAlgorithmsProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataCredentialResolver;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataLocator;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPSamlRegisteredServiceCriterion;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.crypto.DecryptionException;
import org.apereo.cas.util.crypto.PrivateKeyFactoryBean;
import org.apereo.cas.util.function.FunctionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.EncryptedAttribute;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.saml.saml2.encryption.Encrypter;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.AlgorithmPolicyConfiguration;
import org.opensaml.xmlsec.DecryptionConfiguration;
import org.opensaml.xmlsec.DecryptionParameters;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.criterion.DecryptionConfigurationCriterion;
import org.opensaml.xmlsec.criterion.EncryptionConfigurationCriterion;
import org.opensaml.xmlsec.criterion.EncryptionOptionalCriterion;
import org.opensaml.xmlsec.encryption.support.ChainingEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.KeyEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xmlsec.impl.BasicDecryptionConfiguration;
import org.opensaml.xmlsec.impl.BasicDecryptionParametersResolver;
import org.opensaml.xmlsec.impl.BasicEncryptionConfiguration;
import org.opensaml.xmlsec.impl.BasicEncryptionParametersResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.DEREncodedKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.DSAKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.KeyInfoReferenceProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.RSAKeyValueProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class SamlIdPObjectEncrypter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPObjectEncrypter.class);
    private final SamlIdPProperties samlIdPProperties;
    private final SamlIdPMetadataLocator samlIdPMetadataLocator;

    private static void handleEncryptionFailure(SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) {
        String entityId = adaptor.getEntityId();
        if (!service.isEncryptionOptional()) {
            throw new SamlException("Unable to encrypt assertion for " + entityId);
        }
        LOGGER.debug("Skipping to encrypt; No encrypter can be determined and encryption is optional for [{}]", (Object)entityId);
    }

    public EncryptedAssertion encode(Assertion samlObject, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) {
        try {
            Encrypter encrypter = this.buildEncrypterForSamlObject(samlObject, service, adaptor);
            if (encrypter != null) {
                return encrypter.encrypt(samlObject);
            }
        }
        catch (Exception e) {
            SamlIdPObjectEncrypter.handleEncryptionFailure(service, adaptor);
        }
        return null;
    }

    public EncryptedID encode(NameID samlObject, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) {
        try {
            Encrypter encrypter = this.buildEncrypterForSamlObject(samlObject, service, adaptor);
            if (encrypter != null) {
                return encrypter.encrypt(samlObject);
            }
        }
        catch (Exception e) {
            SamlIdPObjectEncrypter.handleEncryptionFailure(service, adaptor);
        }
        return null;
    }

    public EncryptedAttribute encode(Attribute samlObject, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) {
        try {
            Encrypter encrypter = this.buildEncrypterForSamlObject(samlObject, service, adaptor);
            if (encrypter != null) {
                return encrypter.encrypt(samlObject);
            }
        }
        catch (Exception e) {
            SamlIdPObjectEncrypter.handleEncryptionFailure(service, adaptor);
        }
        return null;
    }

    public NameID decode(EncryptedID encryptedId, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            BasicDecryptionConfiguration config = this.configureDecryptionSecurityConfiguration(service);
            this.configureKeyDecryptionCredential(adaptor.getEntityId(), adaptor, service, config);
            DecryptionParameters parameters = this.resolveDecryptionParameters(service, config);
            Decrypter decrypter = this.getDecrypter(encryptedId, service, adaptor, parameters);
            return (NameID)decrypter.decrypt(encryptedId);
        }
        catch (Exception e) {
            throw new DecryptionException((Throwable)e);
        }
    }

    protected Encrypter buildEncrypterForSamlObject(Object samlObject, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) {
        String entityId = adaptor.getEntityId();
        LOGGER.trace("Calculating encryption security configuration for [{}] based on service [{}]", (Object)entityId, (Object)service.getName());
        BasicEncryptionConfiguration encryptionConfiguration = this.configureEncryptionSecurityConfiguration(service);
        FunctionUtils.doUnchecked(u -> {
            LOGGER.trace("Fetching key encryption credential for [{}] based on service [{}]", (Object)entityId, (Object)service.getName());
            this.configureKeyEncryptionCredential(entityId, adaptor, service, encryptionConfiguration);
        }, (Object[])new Object[0]);
        LOGGER.trace("Fetching key encryption parameters for [{}] based on service [{}]", (Object)entityId, (Object)service.getName());
        KeyEncryptionParameters keyEncParams = this.getKeyEncryptionParameters(samlObject, service, adaptor, encryptionConfiguration);
        if (keyEncParams != null) {
            LOGGER.trace("Key encryption algorithm for [{}] is [{}]", (Object)keyEncParams.getRecipient(), (Object)keyEncParams.getAlgorithm());
        }
        LOGGER.trace("Fetching data encryption parameters for [{}] based on service [{}]", (Object)entityId, (Object)service.getName());
        DataEncryptionParameters dataEncParams = this.getDataEncryptionParameters(samlObject, service, adaptor, encryptionConfiguration);
        if (dataEncParams != null) {
            LOGGER.trace("Data encryption algorithm for [{}] is [{}]", (Object)entityId, (Object)dataEncParams.getAlgorithm());
        }
        LOGGER.trace("Building encrypter component for [{}]", (Object)entityId);
        return this.getEncrypter(samlObject, service, adaptor, keyEncParams, dataEncParams);
    }

    protected Encrypter getEncrypter(Object samlObject, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, KeyEncryptionParameters keyEncParams, DataEncryptionParameters dataEncParams) {
        String entityId = adaptor.getEntityId();
        String className = samlObject.getClass().getName();
        Encrypter encrypter = new Encrypter(dataEncParams, keyEncParams);
        encrypter.setKeyPlacement(Encrypter.KeyPlacement.PEER);
        LOGGER.debug("Attempting to encrypt [{}] for [{}] with key placement of [{}]", new Object[]{className, entityId, encrypter.getKeyPlacement()});
        return encrypter;
    }

    protected DataEncryptionParameters getDataEncryptionParameters(Object samlObject, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, BasicEncryptionConfiguration encryptionConfiguration) {
        try {
            EncryptionParameters params = this.resolveEncryptionParameters(service, encryptionConfiguration);
            if (params != null) {
                return new DataEncryptionParameters(params);
            }
            LOGGER.debug("No data encryption parameters could be determined");
            return null;
        }
        catch (Exception e) {
            throw new SamlException(e.getMessage(), (Throwable)e);
        }
    }

    protected KeyEncryptionParameters getKeyEncryptionParameters(Object samlObject, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, BasicEncryptionConfiguration encryptionConfiguration) {
        try {
            EncryptionParameters params = this.resolveEncryptionParameters(service, encryptionConfiguration);
            if (params != null) {
                return new KeyEncryptionParameters(params, adaptor.getEntityId());
            }
            LOGGER.debug("No key encryption parameters could be determined");
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected Credential configureKeyEncryptionCredential(String peerEntityId, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, SamlRegisteredService service, BasicEncryptionConfiguration encryptionConfiguration) throws Exception {
        SamlIdPMetadataCredentialResolver mdCredentialResolver = new SamlIdPMetadataCredentialResolver();
        ArrayList<Object> providers = new ArrayList<Object>(5);
        providers.add(new RSAKeyValueProvider());
        providers.add(new DSAKeyValueProvider());
        providers.add(new InlineX509DataProvider());
        providers.add(new DEREncodedKeyValueProvider());
        providers.add(new KeyInfoReferenceProvider());
        BasicProviderKeyInfoCredentialResolver keyInfoResolver = new BasicProviderKeyInfoCredentialResolver(providers);
        mdCredentialResolver.setKeyInfoCredentialResolver((KeyInfoCredentialResolver)keyInfoResolver);
        RoleDescriptorResolver roleDescriptorResolver = SamlIdPUtils.getRoleDescriptorResolver((SamlRegisteredServiceServiceProviderMetadataFacade)adaptor, (boolean)this.samlIdPProperties.getMetadata().getCore().isRequireValidMetadata());
        mdCredentialResolver.setRoleDescriptorResolver(roleDescriptorResolver);
        mdCredentialResolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new EncryptionConfigurationCriterion(new EncryptionConfiguration[]{encryptionConfiguration}));
        criteriaSet.add((Object)new EntityIdCriterion(peerEntityId));
        criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        criteriaSet.add((Object)new UsageCriterion(UsageType.ENCRYPTION));
        criteriaSet.add((Object)new SamlIdPSamlRegisteredServiceCriterion(service));
        LOGGER.debug("Attempting to resolve the encryption key for entity id [{}]", (Object)peerEntityId);
        Credential credential = mdCredentialResolver.resolveSingle(criteriaSet);
        if (credential == null || credential.getPublicKey() == null) {
            if (service.isEncryptionOptional()) {
                LOGGER.warn("Unable to resolve the encryption [public] key for entity id [{}]", (Object)peerEntityId);
                return null;
            }
            throw new SamlException("Unable to resolve the encryption [public] key for entity id " + peerEntityId);
        }
        String encodedKey = EncodingUtils.encodeBase64((byte[])credential.getPublicKey().getEncoded());
        LOGGER.debug("Found encryption public key: [{}]", (Object)encodedKey);
        encryptionConfiguration.setKeyTransportEncryptionCredentials(CollectionUtils.wrapList((Object[])new Credential[]{credential}));
        return credential;
    }

    protected EncryptionParameters resolveEncryptionParameters(SamlRegisteredService service, BasicEncryptionConfiguration encryptionConfiguration) throws ResolverException {
        CriteriaSet criteria = new CriteriaSet();
        criteria.add((Object)new EncryptionConfigurationCriterion(new EncryptionConfiguration[]{encryptionConfiguration}));
        criteria.add((Object)new EncryptionOptionalCriterion(service.isEncryptionOptional()));
        return new BasicEncryptionParametersResolver().resolveSingle(criteria);
    }

    protected BasicEncryptionConfiguration configureEncryptionSecurityConfiguration(SamlRegisteredService service) {
        List overrideWhiteListedAlgorithms;
        List overrideBlockedEncryptionAlgorithms;
        List overrideKeyEncryptionAlgorithms;
        List overrideDataEncryptionAlgorithms;
        BasicEncryptionConfiguration config = DefaultSecurityConfigurationBootstrap.buildDefaultEncryptionConfiguration();
        LOGGER.trace("Default encryption blocked algorithms: [{}]", (Object)config.getExcludedAlgorithms());
        LOGGER.trace("Default encryption key algorithms: [{}]", (Object)config.getKeyTransportEncryptionAlgorithms());
        LOGGER.trace("Default encryption data algorithms: [{}]", (Object)config.getDataEncryptionAlgorithms());
        LOGGER.trace("Default encryption allowed algorithms: [{}]", (Object)config.getIncludedAlgorithms());
        SamlIdPAlgorithmsProperties globalAlgorithms = this.samlIdPProperties.getAlgs();
        List list = overrideDataEncryptionAlgorithms = service.getEncryptionDataAlgorithms().isEmpty() ? globalAlgorithms.getOverrideDataEncryptionAlgorithms() : service.getEncryptionDataAlgorithms();
        if (overrideDataEncryptionAlgorithms != null && !overrideDataEncryptionAlgorithms.isEmpty()) {
            config.setDataEncryptionAlgorithms(overrideDataEncryptionAlgorithms);
        }
        List list2 = overrideKeyEncryptionAlgorithms = service.getEncryptionKeyAlgorithms().isEmpty() ? globalAlgorithms.getOverrideKeyEncryptionAlgorithms() : service.getEncryptionKeyAlgorithms();
        if (overrideKeyEncryptionAlgorithms != null && !overrideKeyEncryptionAlgorithms.isEmpty()) {
            config.setKeyTransportEncryptionAlgorithms(overrideKeyEncryptionAlgorithms);
        }
        List list3 = overrideBlockedEncryptionAlgorithms = service.getEncryptionBlackListedAlgorithms().isEmpty() ? globalAlgorithms.getOverrideBlockedEncryptionAlgorithms() : service.getEncryptionBlackListedAlgorithms();
        if (overrideBlockedEncryptionAlgorithms != null && !overrideBlockedEncryptionAlgorithms.isEmpty()) {
            config.setExcludedAlgorithms((Collection)overrideBlockedEncryptionAlgorithms);
        }
        List list4 = overrideWhiteListedAlgorithms = service.getEncryptionWhiteListedAlgorithms().isEmpty() ? globalAlgorithms.getOverrideAllowedAlgorithms() : service.getEncryptionWhiteListedAlgorithms();
        if (overrideWhiteListedAlgorithms != null && !overrideWhiteListedAlgorithms.isEmpty()) {
            config.setIncludedAlgorithms((Collection)overrideWhiteListedAlgorithms);
        }
        LOGGER.trace("Finalized encryption blocked algorithms: [{}]", (Object)config.getExcludedAlgorithms());
        LOGGER.trace("Finalized encryption key algorithms: [{}]", (Object)config.getKeyTransportEncryptionAlgorithms());
        LOGGER.trace("Finalized encryption data algorithms: [{}]", (Object)config.getDataEncryptionAlgorithms());
        LOGGER.trace("Finalized encryption allowed algorithms: [{}]", (Object)config.getIncludedAlgorithms());
        if (StringUtils.isNotBlank((CharSequence)service.getWhiteListBlackListPrecedence())) {
            AlgorithmPolicyConfiguration.Precedence precedence = AlgorithmPolicyConfiguration.Precedence.valueOf((String)service.getWhiteListBlackListPrecedence().trim().toUpperCase());
            config.setIncludeExcludePrecedence(precedence);
        }
        return config;
    }

    protected Decrypter getDecrypter(Object samlObject, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, DecryptionParameters decryptionParameters) {
        Decrypter decrypter = new Decrypter(decryptionParameters);
        decrypter.setRootInNewDocument(true);
        return decrypter;
    }

    protected Credential configureKeyDecryptionCredential(String peerEntityId, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, SamlRegisteredService service, BasicDecryptionConfiguration decryptionConfiguration) throws Exception {
        SamlIdPMetadataCredentialResolver mdCredentialResolver = new SamlIdPMetadataCredentialResolver();
        ArrayList<Object> providers = new ArrayList<Object>(5);
        providers.add(new RSAKeyValueProvider());
        providers.add(new DSAKeyValueProvider());
        providers.add(new InlineX509DataProvider());
        providers.add(new DEREncodedKeyValueProvider());
        providers.add(new KeyInfoReferenceProvider());
        BasicProviderKeyInfoCredentialResolver keyInfoResolver = new BasicProviderKeyInfoCredentialResolver(providers);
        mdCredentialResolver.setKeyInfoCredentialResolver((KeyInfoCredentialResolver)keyInfoResolver);
        RoleDescriptorResolver roleDescriptorResolver = SamlIdPUtils.getRoleDescriptorResolver((SamlRegisteredServiceServiceProviderMetadataFacade)adaptor, (boolean)this.samlIdPProperties.getMetadata().getCore().isRequireValidMetadata());
        mdCredentialResolver.setRoleDescriptorResolver(roleDescriptorResolver);
        mdCredentialResolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new DecryptionConfigurationCriterion(new DecryptionConfiguration[]{decryptionConfiguration}));
        criteriaSet.add((Object)new EntityIdCriterion(peerEntityId));
        criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        criteriaSet.add((Object)new UsageCriterion(UsageType.ENCRYPTION));
        criteriaSet.add((Object)new SamlIdPSamlRegisteredServiceCriterion(service));
        LOGGER.debug("Attempting to resolve the decryption key for entity id [{}]", (Object)peerEntityId);
        Credential credential = Objects.requireNonNull(mdCredentialResolver.resolveSingle(criteriaSet));
        Resource encryptinKey = this.samlIdPMetadataLocator.resolveEncryptionKey(Optional.ofNullable(service));
        PrivateKeyFactoryBean bean = new PrivateKeyFactoryBean();
        bean.setSingleton(false);
        bean.setLocation(encryptinKey);
        PrivateKey privateKey = Objects.requireNonNull((PrivateKey)bean.getObject());
        BasicCredential basicCredential = new BasicCredential(Objects.requireNonNull(credential.getPublicKey()), privateKey);
        decryptionConfiguration.setKEKKeyInfoCredentialResolver((KeyInfoCredentialResolver)new StaticKeyInfoCredentialResolver((Credential)basicCredential));
        ArrayList<Object> list = new ArrayList<Object>(3);
        list.add(new InlineEncryptedKeyResolver());
        list.add(new EncryptedElementTypeEncryptedKeyResolver());
        list.add(new SimpleRetrievalMethodEncryptedKeyResolver());
        ChainingEncryptedKeyResolver encryptedKeyResolver = new ChainingEncryptedKeyResolver(list);
        decryptionConfiguration.setEncryptedKeyResolver((EncryptedKeyResolver)encryptedKeyResolver);
        return credential;
    }

    protected BasicDecryptionConfiguration configureDecryptionSecurityConfiguration(SamlRegisteredService service) {
        List overrideWhiteListedAlgorithms;
        List overrideBlockedEncryptionAlgorithms;
        BasicDecryptionConfiguration config = DefaultSecurityConfigurationBootstrap.buildDefaultDecryptionConfiguration();
        LOGGER.trace("Default decryption blocked algorithms: [{}]", (Object)config.getExcludedAlgorithms());
        LOGGER.trace("Default decryption allowed algorithms: [{}]", (Object)config.getIncludedAlgorithms());
        SamlIdPAlgorithmsProperties globalAlgorithms = this.samlIdPProperties.getAlgs();
        List list = overrideBlockedEncryptionAlgorithms = service.getEncryptionBlackListedAlgorithms().isEmpty() ? globalAlgorithms.getOverrideBlockedEncryptionAlgorithms() : service.getEncryptionBlackListedAlgorithms();
        if (overrideBlockedEncryptionAlgorithms != null && !overrideBlockedEncryptionAlgorithms.isEmpty()) {
            config.setExcludedAlgorithms((Collection)overrideBlockedEncryptionAlgorithms);
        }
        List list2 = overrideWhiteListedAlgorithms = service.getEncryptionWhiteListedAlgorithms().isEmpty() ? globalAlgorithms.getOverrideAllowedAlgorithms() : service.getEncryptionWhiteListedAlgorithms();
        if (overrideWhiteListedAlgorithms != null && !overrideWhiteListedAlgorithms.isEmpty()) {
            config.setIncludedAlgorithms((Collection)overrideWhiteListedAlgorithms);
        }
        LOGGER.trace("Finalized decryption blocked algorithms: [{}]", (Object)config.getExcludedAlgorithms());
        LOGGER.trace("Finalized decryption allowed algorithms: [{}]", (Object)config.getIncludedAlgorithms());
        if (StringUtils.isNotBlank((CharSequence)service.getWhiteListBlackListPrecedence())) {
            AlgorithmPolicyConfiguration.Precedence precedence = AlgorithmPolicyConfiguration.Precedence.valueOf((String)service.getWhiteListBlackListPrecedence().trim().toUpperCase());
            config.setIncludeExcludePrecedence(precedence);
        }
        return config;
    }

    protected DecryptionParameters resolveDecryptionParameters(SamlRegisteredService service, BasicDecryptionConfiguration decryptionConfiguration) throws ResolverException {
        CriteriaSet criteria = new CriteriaSet();
        criteria.add((Object)new DecryptionConfigurationCriterion(new DecryptionConfiguration[]{decryptionConfiguration}));
        return new BasicDecryptionParametersResolver().resolveSingle(criteria);
    }

    @Generated
    public SamlIdPObjectEncrypter(SamlIdPProperties samlIdPProperties, SamlIdPMetadataLocator samlIdPMetadataLocator) {
        this.samlIdPProperties = samlIdPProperties;
        this.samlIdPMetadataLocator = samlIdPMetadataLocator;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

