/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategyConfigurer;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.ServiceFactoryConfigurer;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.authentication.SamlIdPServiceFactory;
import org.apereo.cas.support.saml.services.SamlIdPEntityIdAuthenticationServiceSelectionStrategy;
import org.apereo.cas.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Configuration(value="SamlIdPAuthenticationServiceSelectionStrategyConfiguration", proxyBeanMethods=false)
public class SamlIdPAuthenticationServiceSelectionStrategyConfiguration {

    @Configuration(value="SamlIdPAuthenticationServiceFactoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPAuthenticationServiceFactoryConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"samlIdPServiceFactory"})
        public ServiceFactory samlIdPServiceFactory() {
            return new SamlIdPServiceFactory();
        }

        @Bean
        public ServiceFactoryConfigurer samlIdPServiceFactoryConfigurer(@Qualifier(value="samlIdPServiceFactory") ServiceFactory samlIdPServiceFactory) {
            return () -> CollectionUtils.wrap((Object)samlIdPServiceFactory);
        }
    }

    @Configuration(value="SamlIdPAuthenticationServiceSelectionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPAuthenticationServiceSelectionConfiguration {
        @ConditionalOnMissingBean(name={"samlIdPEntityIdValidationServiceSelectionStrategy"})
        @Bean
        public AuthenticationServiceSelectionStrategy samlIdPEntityIdValidationServiceSelectionStrategy(CasConfigurationProperties casProperties, @Qualifier(value="samlIdPServiceFactory") ServiceFactory samlIdPServiceFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new SamlIdPEntityIdAuthenticationServiceSelectionStrategy(servicesManager, samlIdPServiceFactory, casProperties.getServer().getPrefix());
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlIdPAuthenticationServiceSelectionStrategyConfigurer"})
        public AuthenticationServiceSelectionStrategyConfigurer samlIdPAuthenticationServiceSelectionStrategyConfigurer(@Qualifier(value="samlIdPEntityIdValidationServiceSelectionStrategy") AuthenticationServiceSelectionStrategy samlIdPEntityIdValidationServiceSelectionStrategy) {
            return plan -> plan.registerStrategy(samlIdPEntityIdValidationServiceSelectionStrategy);
        }
    }
}

