/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.client;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.support.spnego.util.ReverseDNSRunnable;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class BaseSpnegoKnownClientSystemsFilterAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseSpnegoKnownClientSystemsFilterAction.class);
    private Pattern ipsToCheckPattern;
    private String alternativeRemoteHostAttribute;
    private long timeout;

    protected Event doExecute(RequestContext context) throws Exception {
        String remoteIp = this.getRemoteIp(context);
        LOGGER.debug("Current user IP [{}]", (Object)remoteIp);
        if (this.shouldDoSpnego(remoteIp)) {
            LOGGER.info("Spnego should be activated for [{}]", (Object)remoteIp);
            return this.yes();
        }
        LOGGER.info("Spnego is skipped for [{}]", (Object)remoteIp);
        return this.no();
    }

    protected boolean shouldDoSpnego(String remoteIp) throws Exception {
        return this.ipPatternCanBeChecked(remoteIp) && this.ipPatternMatches(remoteIp);
    }

    protected boolean ipPatternCanBeChecked(String remoteIp) {
        return this.ipsToCheckPattern != null && StringUtils.isNotBlank((CharSequence)remoteIp);
    }

    protected boolean ipPatternMatches(String remoteIp) {
        Matcher matcher = this.ipsToCheckPattern.matcher(remoteIp);
        if (matcher.find()) {
            LOGGER.debug("Remote IP address [{}] should be checked based on the defined pattern [{}]", (Object)remoteIp, (Object)this.ipsToCheckPattern.pattern());
            return true;
        }
        LOGGER.debug("No pattern or remote IP defined, or pattern does not match remote IP [{}]", (Object)remoteIp);
        return false;
    }

    protected String getRemoteHostName(String remoteIp) {
        ReverseDNSRunnable revDNS = new ReverseDNSRunnable(remoteIp);
        Thread t = new Thread((Runnable)revDNS);
        t.start();
        try {
            t.join(this.timeout);
        }
        catch (InterruptedException e) {
            LOGGER.debug("Threaded lookup failed. Defaulting to IP [{}].", (Object)remoteIp, (Object)e);
            Thread.currentThread().interrupt();
        }
        String remoteHostName = revDNS.getHostName();
        LOGGER.debug("Found remote host name [{}].", (Object)remoteHostName);
        return StringUtils.isNotBlank((CharSequence)remoteHostName) ? remoteHostName : remoteIp;
    }

    private String getRemoteIp(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        String userAddress = request.getRemoteAddr();
        LOGGER.debug("Remote Address = [{}]", (Object)userAddress);
        if (StringUtils.isNotBlank((CharSequence)this.alternativeRemoteHostAttribute)) {
            userAddress = request.getHeader(this.alternativeRemoteHostAttribute);
            LOGGER.debug("Header Attribute [{}] = [{}]", (Object)this.alternativeRemoteHostAttribute, (Object)userAddress);
            if (StringUtils.isBlank((CharSequence)userAddress)) {
                userAddress = request.getRemoteAddr();
                LOGGER.warn("No value could be retrieved from the header [{}]. Falling back to [{}].", (Object)this.alternativeRemoteHostAttribute, (Object)userAddress);
            }
        }
        return userAddress;
    }

    @Generated
    public String toString() {
        return "BaseSpnegoKnownClientSystemsFilterAction(ipsToCheckPattern=" + this.ipsToCheckPattern + ", alternativeRemoteHostAttribute=" + this.alternativeRemoteHostAttribute + ", timeout=" + this.timeout + ")";
    }

    @Generated
    public void setIpsToCheckPattern(Pattern ipsToCheckPattern) {
        this.ipsToCheckPattern = ipsToCheckPattern;
    }

    @Generated
    public void setAlternativeRemoteHostAttribute(String alternativeRemoteHostAttribute) {
        this.alternativeRemoteHostAttribute = alternativeRemoteHostAttribute;
    }

    @Generated
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Generated
    public Pattern getIpsToCheckPattern() {
        return this.ipsToCheckPattern;
    }

    @Generated
    public String getAlternativeRemoteHostAttribute() {
        return this.alternativeRemoteHostAttribute;
    }

    @Generated
    public long getTimeout() {
        return this.timeout;
    }

    @Generated
    public BaseSpnegoKnownClientSystemsFilterAction(Pattern ipsToCheckPattern, String alternativeRemoteHostAttribute, long timeout) {
        this.ipsToCheckPattern = ipsToCheckPattern;
        this.alternativeRemoteHostAttribute = alternativeRemoteHostAttribute;
        this.timeout = timeout;
    }
}

