/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.client;

import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.web.flow.client.BaseSpnegoKnownClientSystemsFilterAction;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class LdapSpnegoKnownClientSystemsFilterAction
extends BaseSpnegoKnownClientSystemsFilterAction
implements DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapSpnegoKnownClientSystemsFilterAction.class);
    private final String spnegoAttributeName;
    private final SearchOperation searchOperation;

    public LdapSpnegoKnownClientSystemsFilterAction(Pattern ipsToCheckPattern, String alternativeRemoteHostAttribute, long dnsTimeout, SearchOperation searchOperation, String spnegoAttributeName) {
        super(ipsToCheckPattern, alternativeRemoteHostAttribute, dnsTimeout);
        this.spnegoAttributeName = spnegoAttributeName;
        this.searchOperation = searchOperation;
    }

    public void destroy() {
        this.searchOperation.getConnectionFactory().close();
    }

    @Override
    protected boolean shouldDoSpnego(String remoteIp) throws Exception {
        boolean ipCheck = this.ipPatternCanBeChecked(remoteIp);
        if (ipCheck && !this.ipPatternMatches(remoteIp)) {
            return false;
        }
        LOGGER.debug("Attempting to locate attribute [{}] for [{}]", (Object)this.spnegoAttributeName, (Object)remoteIp);
        return this.executeSearchForSpnegoAttribute(remoteIp);
    }

    @Override
    protected String getRemoteHostName(String remoteIp) {
        if ("localhost".equalsIgnoreCase(remoteIp) || remoteIp.startsWith("127.")) {
            return remoteIp;
        }
        return super.getRemoteHostName(remoteIp);
    }

    protected boolean executeSearchForSpnegoAttribute(String remoteIp) throws Exception {
        String remoteHostName = this.getRemoteHostName(remoteIp);
        LOGGER.debug("Resolved remote hostname [{}] based on ip [{}]", (Object)remoteHostName, (Object)remoteIp);
        SearchOperation searchOp = SearchOperation.copy((SearchOperation)this.searchOperation);
        searchOp.getTemplate().setParameter("host", (Object)remoteHostName);
        LOGGER.debug("Using search filter [{}] on baseDn [{}]", (Object)searchOp.getTemplate().format(), (Object)searchOp.getRequest().getBaseDn());
        SearchResponse searchResult = searchOp.execute();
        if (searchResult.isSuccess()) {
            return this.processSpnegoAttribute(searchResult);
        }
        throw new IllegalArgumentException("Failed to establish a connection ldap. " + searchResult.getDiagnosticMessage());
    }

    protected boolean processSpnegoAttribute(SearchResponse searchResult) {
        if (searchResult == null || searchResult.getEntries().isEmpty()) {
            LOGGER.debug("Spnego attribute is not found in the search results");
            return false;
        }
        LdapEntry entry = searchResult.getEntry();
        LdapAttribute attribute = entry.getAttribute(this.spnegoAttributeName);
        LOGGER.debug("Spnego attribute [{}] found as [{}] for [{}]", new Object[]{attribute.getName(), attribute.getStringValue(), entry.getDn()});
        return this.verifySpnegoAttributeValue(attribute);
    }

    protected boolean verifySpnegoAttributeValue(LdapAttribute attribute) {
        return attribute != null && StringUtils.isNotBlank((CharSequence)attribute.getStringValue());
    }
}

