/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SpnegoNegotiateCredentialsAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SpnegoNegotiateCredentialsAction.class);
    private final List<String> supportedBrowser;
    private final boolean ntlm;
    private final boolean mixedModeAuthentication;

    protected Event doExecute(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
        String authorizationHeader = request.getHeader("Authorization");
        String userAgent = HttpRequestUtils.getHttpServletRequestUserAgent((HttpServletRequest)request);
        LOGGER.debug("Authorization header [{}], User Agent header [{}]", (Object)authorizationHeader, (Object)userAgent);
        if (!StringUtils.hasText((String)userAgent) || this.supportedBrowser.isEmpty()) {
            LOGGER.warn("User Agent header [{}] is empty, or no browsers are supported", (Object)userAgent);
            return this.error();
        }
        if (!this.isSupportedBrowser(userAgent)) {
            LOGGER.warn("User Agent header [{}] is not supported in the list of supported browsers [{}]", (Object)userAgent, this.supportedBrowser);
            return this.error();
        }
        String prefix = this.constructMessagePrefix();
        if (!StringUtils.hasText((String)authorizationHeader) || !authorizationHeader.startsWith(prefix) || authorizationHeader.length() <= prefix.length()) {
            String wwwHeader = this.ntlm ? "NTLM" : "Negotiate";
            LOGGER.debug("Authorization header not found or does not match the message prefix [{}]. Sending [{}] header [{}]", new Object[]{prefix, "WWW-Authenticate", wwwHeader});
            response.setHeader("WWW-Authenticate", wwwHeader);
            response.setStatus(401);
            if (!this.mixedModeAuthentication) {
                LOGGER.debug("Mixed-mode authentication is disabled. Executing completion of response");
                context.getExternalContext().recordResponseComplete();
            } else {
                LOGGER.debug("Mixed-mode authentication is enabled");
            }
        }
        return this.success();
    }

    protected String constructMessagePrefix() {
        return (this.ntlm ? "NTLM" : "Negotiate") + " ";
    }

    protected boolean isSupportedBrowser(String userAgent) {
        return this.supportedBrowser.stream().anyMatch(userAgent::contains);
    }

    @Generated
    public SpnegoNegotiateCredentialsAction(List<String> supportedBrowser, boolean ntlm, boolean mixedModeAuthentication) {
        this.supportedBrowser = supportedBrowser;
        this.ntlm = ntlm;
        this.mixedModeAuthentication = mixedModeAuthentication;
    }
}

