/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.SpnegoCasMultifactorWebflowCustomizer;
import org.apereo.cas.web.flow.SpnegoWebflowConfigurer;
import org.apereo.cas.web.flow.configurer.CasMultifactorWebflowCustomizer;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.SPNEGO)
@AutoConfiguration
public class SpnegoWebflowConfiguration {
    @ConditionalOnMissingBean(name={"spnegoWebflowConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasWebflowConfigurer spnegoWebflowConfigurer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
        return new SpnegoWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"spnegoCasMultifactorWebflowCustomizer"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasMultifactorWebflowCustomizer spnegoCasMultifactorWebflowCustomizer() {
        return new SpnegoCasMultifactorWebflowCustomizer();
    }

    @Bean
    @ConditionalOnMissingBean(name={"spnegoCasWebflowExecutionPlanConfigurer"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasWebflowExecutionPlanConfigurer spnegoCasWebflowExecutionPlanConfigurer(@Qualifier(value="spnegoWebflowConfigurer") CasWebflowConfigurer spnegoWebflowConfigurer) {
        return plan -> plan.registerWebflowConfigurer(spnegoWebflowConfigurer);
    }
}

