/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.view;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.HttpRequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ThemeResolver;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresource.ClassLoaderTemplateResource;
import org.thymeleaf.templateresource.ITemplateResource;

public class ThemeClassLoaderTemplateResolver
extends ClassLoaderTemplateResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemeClassLoaderTemplateResolver.class);
    private final ThemeResolver themeResolver;

    protected ITemplateResource computeTemplateResource(IEngineConfiguration configuration, String ownerTemplate, String template, String resourceName, String characterEncoding, Map<String, Object> templateResolutionAttributes) {
        String themeTemplate;
        ClassLoaderTemplateResource resource;
        HttpServletRequest request = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
        String themeName = this.themeResolver.resolveThemeName(request);
        if (StringUtils.isNotBlank((CharSequence)themeName) && (resource = new ClassLoaderTemplateResource(themeTemplate = String.format(resourceName, themeName), StandardCharsets.UTF_8.name())).exists()) {
            LOGGER.trace("Computing template resource [{}]...", (Object)themeTemplate);
            return super.computeTemplateResource(configuration, ownerTemplate, template, themeTemplate, characterEncoding, templateResolutionAttributes);
        }
        return super.computeTemplateResource(configuration, ownerTemplate, template, resourceName, characterEncoding, templateResolutionAttributes);
    }

    @Generated
    public ThemeClassLoaderTemplateResolver(ThemeResolver themeResolver) {
        this.themeResolver = themeResolver;
    }
}

