/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ws.idp.services;

import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.DefaultServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.ws.idp.services.WSFederationRegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsFederationServicesManagerRegisteredServiceLocator
extends DefaultServicesManagerRegisteredServiceLocator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WsFederationServicesManagerRegisteredServiceLocator.class);

    public WsFederationServicesManagerRegisteredServiceLocator() {
        this.setOrder(Integer.MIN_VALUE);
        this.setRegisteredServiceFilter((registeredService, service) -> {
            boolean match = this.supports((RegisteredService)registeredService, (Service)service);
            if (match) {
                WSFederationRegisteredService wsfedService = (WSFederationRegisteredService)registeredService;
                LOGGER.trace("Attempting to locate service [{}] via [{}]", service, (Object)wsfedService);
                match = CollectionUtils.firstElement(service.getAttributes().get("wreply")).map(Object::toString).stream().anyMatch(arg_0 -> ((WSFederationRegisteredService)wsfedService).matches(arg_0));
            }
            return match;
        });
    }

    public boolean supports(RegisteredService registeredService, Service service) {
        return service.getAttributes().containsKey("wreply") && registeredService instanceof WSFederationRegisteredService;
    }
}

